/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadAndBodyOutputStream;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilterTest {
    private static final String HTML40 = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">";
    private static final String HEAD1 = "<HEAD>";
    private static final String HEAD2 = "</HEAD>";
    private static final String HEADLC1 = "<head>";
    private static final String HEADLC2 = "</head>";
    private static final String CONTENT_TYPE_ISO_8859_1 = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">";
    private static final String CONTENT_TYPE_ISO_8859_1_UC = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\" />";
    private static final String CONTENT_TYPE_UTF8 = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">";
    private static final String CONTENT_TYPE_UTF8UC = "<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">";
    private static final String BODY1 = "<BODY>";
    private static final String BODY2 = "</BODY></html>";
    private static final String BODYLC1 = "<body>";
    private static final String BODYLC2 = "</body></html>";
    private static final String CSS1 = "<LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">";
    private static final String CSS2 = "<LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">";
    private static final String CONTENT1 = "<p>Content1</p>";
    private static final String CONTENT2 = "<p>Content2</p>";
    private final String CHINESE_CONTENT = "<p>\u5f00\u53d1\u74ec</p>";
    private final String CHINESE_ENTITY_CONTENT = "<p>&#24320;&#21457;&#29932;</p>";

    @Test
    public void testHeadOutputFilter() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FilterHTMLHeadOutputStream filteredOutput = new FilterHTMLHeadOutputStream((OutputStream)output, "<LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">".getBytes());){
                filteredOutput.write(HTML40.getBytes());
                filteredOutput.write(HEAD1.getBytes());
                filteredOutput.write("<LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">".getBytes());
                filteredOutput.write(HEAD2.getBytes());
                filteredOutput.write(BODY1.getBytes());
                filteredOutput.write(CONTENT1.getBytes());
                filteredOutput.write(BODY2.getBytes());
                filteredOutput.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
        String expected = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HEAD><LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\"><LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">\n</HEAD><BODY><p>Content1</p></BODY></html>";
        Assertions.assertEquals((Object)"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HEAD><LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\"><LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">\n</HEAD><BODY><p>Content1</p></BODY></html>", (Object)output.toString());
    }

    @Test
    public void testHeadAndBodyOutputFilter() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FilterHTMLHeadAndBodyOutputStream filteredOutput = new FilterHTMLHeadAndBodyOutputStream((OutputStream)output, "<LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">".getBytes(), CONTENT2);){
                filteredOutput.write(HTML40.getBytes());
                filteredOutput.write(HEAD1.getBytes());
                filteredOutput.write(CONTENT_TYPE_ISO_8859_1.getBytes());
                filteredOutput.write("<LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">".getBytes());
                filteredOutput.write(HEAD2.getBytes());
                filteredOutput.write(BODY1.getBytes());
                filteredOutput.write(CONTENT1.getBytes());
                filteredOutput.write(BODY2.getBytes());
                filteredOutput.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
        String expected = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"><LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\"><LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">\n</HEAD><BODY>\n<p>Content2</p>\n<p>Content1</p></BODY></html>";
        Assertions.assertEquals((Object)"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"><LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\"><LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">\n</HEAD><BODY>\n<p>Content2</p>\n<p>Content1</p></BODY></html>", (Object)output.toString());
    }

    @Test
    public void testLowerCaseTags() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FilterHTMLHeadAndBodyOutputStream filteredOutput = new FilterHTMLHeadAndBodyOutputStream((OutputStream)output, "<LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">".getBytes(), CONTENT2);){
                filteredOutput.write(HTML40.getBytes());
                filteredOutput.write(HEADLC1.getBytes());
                filteredOutput.write(HEADLC2.getBytes());
                filteredOutput.write(BODYLC1.getBytes());
                filteredOutput.write(CONTENT1.getBytes());
                filteredOutput.write(BODYLC2.getBytes());
                filteredOutput.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
        String expected = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><head><LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">\n</head><body>\n<p>Content2</p>\n<p>Content1</p></body></html>";
        Assertions.assertEquals((Object)"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><head><LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">\n</head><body>\n<p>Content2</p>\n<p>Content1</p></body></html>", (Object)output.toString());
    }

    @Test
    public void testFilterHeadlessDocument() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FilterHTMLHeadAndBodyOutputStream filteredOutput = new FilterHTMLHeadAndBodyOutputStream((OutputStream)output, "<LINK REL=\"STYLESHEET\" HREF=\"book1.css\" TYPE=\"text/css\">".getBytes(), CONTENT2);){
                filteredOutput.write(HTML40.getBytes());
                filteredOutput.write(BODY1.getBytes());
                filteredOutput.write(CONTENT1.getBytes());
                filteredOutput.write(BODY2.getBytes());
                filteredOutput.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
        String expected = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><BODY>\n<p>Content2</p>\n<p>Content1</p></BODY></html>";
        Assertions.assertEquals((Object)"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><BODY>\n<p>Content2</p>\n<p>Content1</p></BODY></html>", (Object)output.toString());
    }

    @Test
    public void testInsertChineseUtf8() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FilterHTMLHeadAndBodyOutputStream filteredOutput = new FilterHTMLHeadAndBodyOutputStream((OutputStream)output, null, "<p>\u5f00\u53d1\u74ec</p>");){
                filteredOutput.write(HTML40.getBytes());
                filteredOutput.write(HEAD1.getBytes());
                filteredOutput.write(CONTENT_TYPE_UTF8.getBytes());
                filteredOutput.write(HEAD2.getBytes());
                filteredOutput.write(BODY1.getBytes());
                filteredOutput.write(BODY2.getBytes());
                filteredOutput.close();
                String expected = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></HEAD><BODY>\n<p>\u5f00\u53d1\u74ec</p>\n</BODY></html>";
                Assertions.assertEquals((Object)"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></HEAD><BODY>\n<p>\u5f00\u53d1\u74ec</p>\n</BODY></html>", (Object)output.toString("UTF-8"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
    }

    @Test
    public void testInsertChineseISO8859() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FilterHTMLHeadAndBodyOutputStream filteredOutput = new FilterHTMLHeadAndBodyOutputStream((OutputStream)output, null, "<p>\u5f00\u53d1\u74ec</p>");){
                filteredOutput.write(HTML40.getBytes());
                filteredOutput.write(HEAD1.getBytes());
                filteredOutput.write(CONTENT_TYPE_ISO_8859_1.getBytes());
                filteredOutput.write(HEAD2.getBytes());
                filteredOutput.write(BODY1.getBytes());
                filteredOutput.write(BODY2.getBytes());
                filteredOutput.close();
                String expected = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"></HEAD><BODY>\n<p>&#24320;&#21457;&#29932;</p>\n</BODY></html>";
                Assertions.assertEquals((Object)"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"></HEAD><BODY>\n<p>&#24320;&#21457;&#29932;</p>\n</BODY></html>", (Object)output.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
    }

    @Test
    public void testInsertChineseNoCharsetSpecified() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FilterHTMLHeadAndBodyOutputStream filteredOutput = new FilterHTMLHeadAndBodyOutputStream((OutputStream)output, null, "<p>\u5f00\u53d1\u74ec</p>");){
                filteredOutput.write(HTML40.getBytes());
                filteredOutput.write(HEAD1.getBytes());
                filteredOutput.write(HEAD2.getBytes());
                filteredOutput.write(BODY1.getBytes());
                filteredOutput.write(BODY2.getBytes());
                filteredOutput.close();
                String expected = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HEAD></HEAD><BODY>\n<p>&#24320;&#21457;&#29932;</p>\n</BODY></html>";
                Assertions.assertEquals((Object)"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HEAD></HEAD><BODY>\n<p>&#24320;&#21457;&#29932;</p>\n</BODY></html>", (Object)output.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
    }

    @Test
    public void testCharsetUtf8Upper() {
        ByteArrayInputStream is = new ByteArrayInputStream(CONTENT_TYPE_UTF8UC.getBytes());
        Assertions.assertEquals((Object)"UTF-8", (Object)HTMLDocParser.getCharsetFromHTML((InputStream)is));
    }

    @Test
    public void testCharsetISO_8859_UCUpper() {
        ByteArrayInputStream is = new ByteArrayInputStream(CONTENT_TYPE_ISO_8859_1_UC.getBytes());
        Assertions.assertEquals((Object)"ISO-8859-1", (Object)HTMLDocParser.getCharsetFromHTML((InputStream)is));
    }
}

