/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import org.eclipse.help.internal.webapp.servlet.TocFragmentServlet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FragmentServletTest {
    private static final String PATH = "1_2";
    private static final String DOC_HTML = "org.eclipse.ua.tests/doc.html";

    @Test
    public void testFixHrefNormal() {
        String href = TocFragmentServlet.fixupHref((String)DOC_HTML, (String)PATH);
        Assertions.assertEquals((Object)"org.eclipse.ua.tests/doc.html?cp=1_2", (Object)href);
    }

    @Test
    public void testFixHrefWithParameter() {
        String href = TocFragmentServlet.fixupHref((String)"org.eclipse.ua.tests/doc.html?a=b", (String)PATH);
        Assertions.assertEquals((Object)"org.eclipse.ua.tests/doc.html?a=b&cp=1_2", (Object)href);
    }

    @Test
    public void testFixHrefNull() {
        String href = TocFragmentServlet.fixupHref(null, (String)PATH);
        Assertions.assertEquals((Object)"/../nav/1_2", (Object)href);
    }

    @Test
    public void testFixHrefWithAnchor() {
        String href = TocFragmentServlet.fixupHref((String)"org.eclipse.ua.tests/doc.html#A", (String)PATH);
        Assertions.assertEquals((Object)"org.eclipse.ua.tests/doc.html?cp=1_2#A", (Object)href);
    }

    @Test
    public void testFixHrefWithAnchorAndParams() {
        String href = TocFragmentServlet.fixupHref((String)"org.eclipse.ua.tests/doc.html?a=b#A", (String)PATH);
        Assertions.assertEquals((Object)"org.eclipse.ua.tests/doc.html?a=b&cp=1_2#A", (Object)href);
    }
}

