/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.server.WebappManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HelpServerBinding {
    private int previousMode;
    private final boolean testUsingIP = false;

    @BeforeEach
    public void setUp() throws Exception {
        this.previousMode = BaseHelpSystem.getMode();
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.previousMode);
    }

    private String getHostIP() throws UnknownHostException {
        InetAddress host = InetAddress.getLocalHost();
        byte[] ipAddr = host.getAddress();
        String result = "" + ipAddr[0];
        int i = 1;
        while (i < ipAddr.length) {
            result = result + ".";
            result = result + ipAddr[i];
            ++i;
        }
        return result;
    }

    @Test
    public void testInfocenterBinding() throws Exception {
        BaseHelpSystem.setMode((int)1);
        WebappManager.stop((String)"help");
        WebappManager.start((String)"help");
        Assertions.assertTrue((boolean)this.canAccessServer("127.0.0.1"));
    }

    @Test
    public void testWorkbenchBinding() throws Exception {
        BaseHelpSystem.setMode((int)0);
        WebappManager.stop((String)"help");
        WebappManager.start((String)"help");
        Assertions.assertTrue((boolean)this.canAccessServer("127.0.0.1"));
    }

    @Test
    public void testStandaloneBinding() throws Exception {
        BaseHelpSystem.setMode((int)2);
        WebappManager.stop((String)"help");
        WebappManager.start((String)"help");
        Assertions.assertTrue((boolean)this.canAccessServer("127.0.0.1"));
    }

    private boolean canAccessServer(String host) throws Exception {
        try {
            int port = WebappManager.getPort();
            URL url = new URL("http", host, port, "/help/index.jsp");
            URLConnection connection = url.openConnection();
            HelpServerBinding.setTimeout(connection, 5000);
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream input = connection.getInputStream();){
                int firstbyte = input.read();
                boolean bl = firstbyte > 0;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void setTimeout(URLConnection conn, int milliseconds) {
        conn.setConnectTimeout(milliseconds);
        conn.setReadTimeout(milliseconds);
    }
}

