/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.server.WebappManager;
import org.junit.jupiter.api.Test;

public class HelpServerInterrupt {
    private static boolean enableTimeout = true;
    private int iterations;
    private final int sleepTime = 10;

    @Test
    public void testServerWithoutInterrupt() throws Exception {
        WebappManager.stop((String)"help");
        this.startServerWithoutInterrupt();
        this.checkServer();
        WebappManager.stop((String)"help");
    }

    @Test
    public void testServerWithInterrupt() throws Exception {
        WebappManager.stop((String)"help");
        this.startServerWithInterrupt();
        this.checkServer();
        WebappManager.stop((String)"help");
    }

    private void startServerWithoutInterrupt() throws Exception {
        ServerStarter starter = new ServerStarter();
        starter.start();
        this.iterations = 0;
        do {
            ++this.iterations;
            if (enableTimeout && 10 * this.iterations > 10000) {
                org.junit.jupiter.api.Assertions.fail((String)"Test did not complete within 10 seconds");
            }
            Thread.sleep(10L);
        } while (starter.isAlive());
        Exception exception = starter.getException();
        if (exception != null) {
            throw exception;
        }
    }

    private void startServerWithInterrupt() throws Exception {
        ServerStarter starter = new ServerStarter();
        starter.start();
        this.iterations = 0;
        do {
            ++this.iterations;
            if (enableTimeout && 10 * this.iterations > 10000) {
                org.junit.jupiter.api.Assertions.fail((String)"Test did not complete within 10 seconds");
            }
            starter.interrupt();
            Thread.sleep(10L);
        } while (starter.isAlive());
        Exception exception = starter.getException();
        if (exception != null) {
            throw exception;
        }
    }

    private void checkServer() throws Exception {
        long start = System.currentTimeMillis();
        try {
            int port = WebappManager.getPort();
            URL url = new URL("http", "localhost", port, "/help/index.jsp");
            URLConnection connection = url.openConnection();
            HelpServerInterrupt.setTimeout(connection, 5000);
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream input = connection.getInputStream();){
                int firstbyte = input.read();
                Assertions.assertThat((int)firstbyte).isGreaterThan(0);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("Fail, milliseconds = " + elapsed);
            throw e;
        }
    }

    private static void setTimeout(URLConnection conn, int milliseconds) {
        conn.setConnectTimeout(milliseconds);
        conn.setReadTimeout(milliseconds);
    }

    private static class ServerStarter
    extends Thread {
        private Exception exception = null;

        private ServerStarter() {
        }

        @Override
        public synchronized void run() {
            try {
                WebappManager.start((String)"help");
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

