/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HtmlCoderTest {
    @Test
    public void testEncodeEmpty() {
        String encoded = UrlUtil.htmlEncode(null);
        Assertions.assertNull((Object)encoded);
    }

    @Test
    public void testEncodeAlpha() {
        String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String encoded = UrlUtil.htmlEncode((String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
        Assertions.assertEquals((Object)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", (Object)encoded);
    }

    @Test
    public void testEncodeNumeric() {
        String numbers = "1234567890";
        String encoded = UrlUtil.htmlEncode((String)"1234567890");
        Assertions.assertEquals((Object)"1234567890", (Object)encoded);
    }

    @Test
    public void testEncodeSpace() {
        String spaces = "  ";
        String encoded = UrlUtil.htmlEncode((String)"  ");
        Assertions.assertEquals((Object)"  ", (Object)encoded);
    }

    @Test
    public void testEncodeQuote() {
        String source = "'";
        String encoded = UrlUtil.htmlEncode((String)"'");
        Assertions.assertNotSame((Object)"'", (Object)encoded);
    }

    @Test
    public void testEncodeLt() {
        String source = "<";
        String encoded = UrlUtil.htmlEncode((String)"<");
        Assertions.assertNotSame((Object)"<", (Object)encoded);
    }

    @Test
    public void testEncodeGt() {
        String source = ">";
        String encoded = UrlUtil.htmlEncode((String)">");
        Assertions.assertNotSame((Object)">", (Object)encoded);
    }

    @Test
    public void testEncodeAmp() {
        String source = "&";
        String encoded = UrlUtil.htmlEncode((String)"&");
        Assertions.assertNotSame((Object)"&", (Object)encoded);
    }

    @Test
    public void testEncodeBackslash() {
        String source = "\\";
        String encoded = UrlUtil.htmlEncode((String)"\\");
        Assertions.assertNotSame((Object)"\\", (Object)encoded);
    }

    @Test
    public void testEncodeNewline() {
        String source = "\n";
        String encoded = UrlUtil.htmlEncode((String)"\n");
        Assertions.assertNotSame((Object)"\n", (Object)encoded);
    }

    @Test
    public void testEncodeCarriageReturn() {
        String source = "\r";
        String encoded = UrlUtil.htmlEncode((String)"\r");
        Assertions.assertNotSame((Object)"\r", (Object)encoded);
    }

    @Test
    public void testNoEncodeAccented() {
        String source = "\u00c1";
        String encoded = UrlUtil.htmlEncode((String)"\u00c1");
        Assertions.assertEquals((Object)"\u00c1", (Object)encoded);
    }

    @Test
    public void testNoEncodeChinese() {
        String source = "\u4e01";
        String encoded = UrlUtil.htmlEncode((String)"\u4e01");
        Assertions.assertEquals((Object)"\u4e01", (Object)encoded);
    }
}

