/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.ua.tests.help.webapp.MockServletRequest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LocaleTest {
    private int mode;

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.mode = BaseHelpSystem.getMode();
    }

    @Test
    public void testFixLocaleNull() {
        Assertions.assertNull((Object)UrlUtil.cleanLocale(null));
    }

    @Test
    public void testFixLocaleWithIllegalChars() {
        Assertions.assertEquals((Object)"ab-cd______ef", (Object)UrlUtil.cleanLocale((String)"ab-cd\n\r_\"'_ef"));
    }

    @Test
    public void testForced_Locale() {
        BaseHelpSystem.setMode((int)1);
        MockServletRequest req = new MockServletRequest();
        req.setLocale(Locale.of("de"));
        req.getParameterMap().put("lang", new String[]{"es"});
        String locale = UrlUtil.getLocale((HttpServletRequest)req, null);
        Assertions.assertEquals((Object)"es", (Object)locale);
    }

    @Test
    public void testForcedLangOverridesCookies() {
        BaseHelpSystem.setMode((int)1);
        MockServletRequest req = new MockServletRequest();
        req.setLocale(Locale.of("de"));
        req.setCookies(new Cookie[]{new Cookie("lang", "it")});
        req.getParameterMap().put("lang", new String[]{"es"});
        String locale = UrlUtil.getLocale((HttpServletRequest)req, null);
        Assertions.assertEquals((Object)"es", (Object)locale);
    }

    @Test
    public void testForcedUsingCookies() {
        BaseHelpSystem.setMode((int)1);
        MockServletRequest req = new MockServletRequest();
        req.setLocale(Locale.of("de"));
        req.setCookies(new Cookie[]{new Cookie("lang", "it")});
        String locale = UrlUtil.getLocale((HttpServletRequest)req, null);
        Assertions.assertEquals((Object)"it", (Object)locale);
    }

    @Test
    public void testGetLocale_De_Standalone() {
        MockServletRequest req = new MockServletRequest();
        BaseHelpSystem.setMode((int)2);
        req.setLocale(Locale.of("de"));
        String locale = UrlUtil.getLocale((HttpServletRequest)req, null);
        Assertions.assertEquals((Object)Platform.getNL(), (Object)locale);
    }

    @Test
    public void testGetLocale_De_Workbench() {
        MockServletRequest req = new MockServletRequest();
        BaseHelpSystem.setMode((int)0);
        req.setLocale(Locale.of("de"));
        String locale = UrlUtil.getLocale((HttpServletRequest)req, null);
        Assertions.assertEquals((Object)Platform.getNL(), (Object)locale);
    }

    @Test
    public void testGetLocale_De_Infocenter() {
        MockServletRequest req = new MockServletRequest();
        BaseHelpSystem.setMode((int)1);
        req.setLocale(Locale.of("de"));
        String locale = UrlUtil.getLocale((HttpServletRequest)req, null);
        Assertions.assertEquals((Object)"de", (Object)locale);
    }

    @Test
    public void testGetLocale_Pt_Br_Infocenter() {
        MockServletRequest req = new MockServletRequest();
        BaseHelpSystem.setMode((int)1);
        req.setLocale(Locale.of("pt", "br"));
        String locale = UrlUtil.getLocale((HttpServletRequest)req, null);
        Assertions.assertEquals((Object)"pt_br", (Object)locale.toLowerCase());
    }

    @Test
    public void testGetLocale_Fr_Ca_To_Infocenter() {
        MockServletRequest req = new MockServletRequest();
        BaseHelpSystem.setMode((int)1);
        req.setLocale(Locale.of("fr", "CA", "to"));
        String locale = UrlUtil.getLocale((HttpServletRequest)req, null);
        Assertions.assertEquals((Object)"fr_CA_to", (Object)locale);
    }

    @Test
    public void testIsRTLWorkbench() {
        MockServletRequest req = new MockServletRequest();
        BaseHelpSystem.setMode((int)0);
        req.setLocale(Locale.of("de"));
        Assertions.assertEquals((Object)ProductPreferences.isRTL(), (Object)UrlUtil.isRTL((HttpServletRequest)req, null));
    }

    @Test
    public void testIsRTLInfocenter_ar() {
        MockServletRequest req = new MockServletRequest();
        BaseHelpSystem.setMode((int)1);
        req.setLocale(Locale.of("ar_SA"));
        Assertions.assertTrue((boolean)UrlUtil.isRTL((HttpServletRequest)req, null));
    }

    @Test
    public void testIsRTLInfocenter_he() {
        MockServletRequest req = new MockServletRequest();
        BaseHelpSystem.setMode((int)1);
        req.setLocale(Locale.of("he"));
        Assertions.assertTrue((boolean)UrlUtil.isRTL((HttpServletRequest)req, null));
    }

    @Test
    public void testIsRTLInfocenter_de() {
        MockServletRequest req = new MockServletRequest();
        BaseHelpSystem.setMode((int)1);
        req.setLocale(Locale.of("de"));
        Assertions.assertFalse((boolean)UrlUtil.isRTL((HttpServletRequest)req, null));
    }

    @Test
    public void testIsRTLInfocenter_en_us() {
        MockServletRequest req = new MockServletRequest();
        BaseHelpSystem.setMode((int)1);
        req.setLocale(Locale.of("en_US"));
        Assertions.assertFalse((boolean)UrlUtil.isRTL((HttpServletRequest)req, null));
    }
}

