/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.ua.tests.help.util.LoadServletUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParallelServerAccessTest {
    long readOperations = 0L;

    @AfterEach
    public void tearDown() throws Exception {
        LoadServletUtil.stopServer();
    }

    @Test
    public void testServletReadInParallel() throws Exception {
        LoadServletUtil.startServer();
        int iterations = 1;
        int i = 0;
        while (i < iterations) {
            this.accessInParallel(10);
            ++i;
        }
    }

    private void accessInParallel(int numberOfThreads) throws Exception {
        int i;
        ReadThread[] readers = new ReadThread[numberOfThreads];
        int i2 = 0;
        while (i2 < numberOfThreads) {
            readers[i2] = new ReadThread();
            ++i2;
        }
        i2 = 0;
        while (i2 < numberOfThreads) {
            readers[i2].start();
            ++i2;
        }
        boolean complete = false;
        int iterations = 0;
        do {
            complete = true;
            if (++iterations > 1000) {
                Assertions.fail((String)"Test did not complete within 100 seconds");
            }
            i = 0;
            while (i < numberOfThreads && complete) {
                if (readers[i].isAlive()) {
                    complete = false;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Assertions.fail((String)"Interrupted Exception");
                    }
                }
                ++i;
            }
        } while (!complete);
        i = 0;
        while (i < numberOfThreads) {
            if (readers[i].exception != null) {
                throw readers[i].exception;
            }
            ++i;
        }
    }

    public void readLoadServlet(int paragraphs) throws Exception {
        int port = WebappManager.getPort();
        long uniqueId = this.getReadOperations();
        URL url = new URL("http", "localhost", port, "/help/loadtest?value=" + uniqueId + "&repeat=" + paragraphs);
        long value = 0L;
        Throwable throwable = null;
        Object var9_8 = null;
        try (InputStream input = url.openStream();){
            int nextChar;
            boolean inFirstComment = true;
            do {
                nextChar = input.read();
                if (!inFirstComment) continue;
                if (nextChar == 62) {
                    inFirstComment = false;
                    continue;
                }
                if (!Character.isDigit((char)nextChar)) continue;
                value = value * 10L + (long)(nextChar - 48);
            } while (nextChar != 36);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (uniqueId != value) {
            throw new UnexpectedValueException(uniqueId, value);
        }
    }

    private synchronized long getReadOperations() {
        return ++this.readOperations;
    }

    private class ReadThread
    extends Thread {
        public Exception exception;

        private ReadThread() {
        }

        @Override
        public void run() {
            int j = 0;
            while (j <= 100) {
                try {
                    ParallelServerAccessTest.this.readLoadServlet(200);
                }
                catch (Exception e) {
                    this.exception = e;
                    e.printStackTrace();
                }
                ++j;
            }
        }
    }

    private static class UnexpectedValueException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final long expected;
        private final long actual;

        UnexpectedValueException(long expected, long actual) {
            this.expected = expected;
            this.actual = actual;
        }

        @Override
        public String getMessage() {
            return "Expected: " + this.expected + " Actual: " + this.actual;
        }
    }
}

