/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.help.internal.webapp.servlet.PluginsRootResolvingStream;
import org.eclipse.ua.tests.util.ResourceFinder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.FrameworkUtil;

public class PluginsRootReplacement {
    @Test
    public void testEmpty() {
        String input = "";
        this.checkFilter("", "");
    }

    @Test
    public void testNoMatch() {
        String input = "<HEAD><HEAD/>";
        this.checkFilter("<HEAD><HEAD/>", "<HEAD><HEAD/>");
    }

    @Test
    public void testPartialMatch() {
        String input = "<A href = \"PLUGINS\">";
        this.checkFilter("<A href = \"PLUGINS\">", "<A href = \"PLUGINS\">");
    }

    @Test
    public void testEndsUnmatched() {
        String input = "<A href = \"PLUGIN";
        this.checkFilter("<A href = \"PLUGIN", "<A href = \"PLUGIN");
    }

    @Test
    public void testNotAtStart() {
        String input = "<A href = \"../PLUGINS_ROOT/plugin/a.html\">";
        this.checkFilter("<A href = \"../PLUGINS_ROOT/plugin/a.html\">", "<A href = \"../PLUGINS_ROOT/plugin/a.html\">");
    }

    @Test
    public void testAtStart() {
        String input = "<A href = \"PLUGINS_ROOT/plugin/a.html\">";
        String expected = "<A href = \"../plugin/a.html\">";
        this.checkFilter("<A href = \"PLUGINS_ROOT/plugin/a.html\">", "<A href = \"../plugin/a.html\">");
    }

    @Test
    public void testSecondArg() {
        String input = "<A alt=\"alt\" href = \"PLUGINS_ROOT/plugin/a.html\">";
        String expected = "<A alt=\"alt\" href = \"../plugin/a.html\">";
        this.checkFilter("<A alt=\"alt\" href = \"PLUGINS_ROOT/plugin/a.html\">", "<A alt=\"alt\" href = \"../plugin/a.html\">");
    }

    @Test
    public void testMultipleMatches() {
        String input = "<A href = \"PLUGINS_ROOT/plugin/a.html\"><A href = \"PLUGINS_ROOT/plugin/b.html\">";
        String expected = "<A href = \"../plugin/a.html\"><A href = \"../plugin/b.html\">";
        this.checkFilter("<A href = \"PLUGINS_ROOT/plugin/a.html\"><A href = \"PLUGINS_ROOT/plugin/b.html\">", "<A href = \"../plugin/a.html\"><A href = \"../plugin/b.html\">");
    }

    private void checkFilter(String input, String expected) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PluginsRootResolvingStream filteredOutput = new PluginsRootResolvingStream((OutputStream)output, null, "../");){
                filteredOutput.write(input.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assertions.fail((String)"IO Exception");
        }
        Assertions.assertEquals((Object)expected, (Object)output.toString());
    }

    @Test
    public void testHelpContentActiveAction() throws IOException {
        String filename = "ua_help_content_active_action.htm";
        this.checkFileContentsPreserved(filename);
    }

    @Test
    public void testHelpContentActiveDebug() throws IOException {
        String filename = "ua_help_content_active_debug.htm";
        this.checkFileContentsPreserved(filename);
    }

    @Test
    public void testHelpContentActiveInvoke() throws IOException {
        String filename = "ua_help_content_active_invoke.htm";
        this.checkFileContentsPreserved(filename);
    }

    @Test
    public void testHelpContentActive() throws IOException {
        String filename = "ua_help_content_active.htm";
        this.checkFileContentsPreserved(filename);
    }

    @Test
    public void testHelpContentManifest() throws IOException {
        String filename = "ua_help_content_manifest.htm";
        this.checkFileContentsPreserved(filename);
    }

    @Test
    public void testHelpContentProcess() throws IOException {
        String filename = "ua_help_content_process.htm";
        this.checkFileContentsPreserved(filename);
    }

    @Test
    public void testHelpContentNested() throws IOException {
        String filename = "ua_help_content_nested.htm";
        this.checkFileContentsPreserved(filename);
    }

    @Test
    public void testHelpContentToc() throws IOException {
        String filename = "ua_help_content_toc.htm";
        this.checkFileContentsPreserved(filename);
    }

    @Test
    public void testHelpContentXhtml() throws IOException {
        String filename = "ua_help_content_xhtml.htm";
        this.checkFileContentsPreserved(filename);
    }

    @Test
    public void testHelpContent() throws IOException {
        String filename = "ua_help_content.htm";
        this.checkFileContentsPreserved(filename);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkFileContentsPreserved(String filename) throws IOException {
        URL testURL = ResourceFinder.findFile(FrameworkUtil.getBundle(PluginsRootReplacement.class), "/data/help/performance/search/" + filename);
        Assertions.assertNotNull((Object)testURL);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream input = testURL.openStream();
            try {
                try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                    while (input.available() > 0) {
                        int next = input.read();
                        output.write(next);
                    }
                    String data = output.toString();
                    this.checkFilter(data, data);
                }
                if (input == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            input.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

