/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import org.eclipse.help.internal.webapp.data.PrintData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PrintSubtopics {
    @Test
    public void testHeadingInsertion() {
        String result = PrintData.injectHeading((String)"<body> <p>Title</p>", (String)"1");
        Assertions.assertEquals((Object)"<body> <p><a id=\"section1\">1. </a>Title</p>", (Object)result);
    }

    @Test
    public void testHeaderInsertionSkipsWhitespace() {
        this.checkHeadingInsertion("<body> <p>  \n\r</p><h1>", "Title</h1>");
    }

    @Test
    public void testAccentedCharacter() {
        this.checkHeadingInsertion("<body> <p>", "\u00e1guila</p>");
    }

    @Test
    public void testinvertedQuestionmark() {
        this.checkHeadingInsertion("<body> <p>", "\u00bfQu\u00e9 es Eclipse?</p>");
    }

    @Test
    public void testSlash() {
        this.checkHeadingInsertion("<body> <p>", "/usr/bin</p>");
    }

    @Test
    public void testChineseCharacter() {
        this.checkHeadingInsertion("<body> <p>", "\u623f\u5b50</p>");
    }

    @Test
    public void testChineseExtbCharacter() {
        this.checkHeadingInsertion("<body> <p>", "\ud840\udc06</p>");
    }

    public void checkHeadingInsertion(String preInsert, String postInsert) {
        String result = PrintData.injectHeading((String)(preInsert + postInsert), (String)"1");
        Assertions.assertEquals((Object)(preInsert + "<a id=\"section1\">1. </a>" + postInsert), (Object)result);
    }
}

