/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RestrictedTopicParameter {
    private static final String RESTRICT_TOPIC = "restrictTopicParameter";
    private boolean restrictTopic;
    private int helpMode;

    @BeforeEach
    public void setUp() throws Exception {
        this.restrictTopic = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", RESTRICT_TOPIC, false, null);
        this.helpMode = BaseHelpSystem.getMode();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.setRestrictTopic(this.restrictTopic);
        BaseHelpSystem.setMode((int)this.helpMode);
    }

    private void setRestrictTopic(boolean isRestrict) {
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        pref.putBoolean(RESTRICT_TOPIC, isRestrict);
    }

    @Test
    public void testWorkbenchMode() {
        BaseHelpSystem.setMode((int)0);
        this.setRestrictTopic(true);
        Assertions.assertFalse((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"http://www.eclipse.org"));
        Assertions.assertFalse((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"https://www.eclipse.org"));
        this.setRestrictTopic(false);
        Assertions.assertTrue((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"http://www.eclipse.org"));
        Assertions.assertTrue((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"https://www.eclipse.org"));
    }

    @Test
    public void testStandaloneMode() {
        BaseHelpSystem.setMode((int)2);
        this.setRestrictTopic(true);
        Assertions.assertFalse((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"http://www.eclipse.org"));
        Assertions.assertFalse((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"https://www.eclipse.org"));
        this.setRestrictTopic(false);
        Assertions.assertTrue((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"http://www.eclipse.org"));
        Assertions.assertTrue((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"https://www.eclipse.org"));
    }

    @Test
    public void testInfocenterUnrestricted() {
        BaseHelpSystem.setMode((int)1);
        this.setRestrictTopic(false);
        Assertions.assertTrue((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"http://www.eclipse.org"));
        Assertions.assertTrue((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"https://www.eclipse.org"));
        Assertions.assertTrue((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"org.eclipse.platform.doc.user/reference/ref-43.htm"));
    }

    @Test
    public void testInfocenterResestricted() {
        BaseHelpSystem.setMode((int)1);
        this.setRestrictTopic(true);
        Assertions.assertFalse((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"http://www.eclipse.org"));
        Assertions.assertFalse((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"https://www.eclipse.org"));
        Assertions.assertFalse((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"HTTP://www.eclipse.org"));
        Assertions.assertFalse((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"file://somepath.html"));
        Assertions.assertTrue((boolean)UrlUtil.isValidTopicParamOrWasOpenedFromHelpDisplay((String)"org.eclipse.platform.doc.user/reference/ref-43.htm"));
    }
}

