/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.junit.jupiter.api.Test;

public class TopicPathTest {
    @Test
    public void testTocOnly() {
        int[] topics = UrlUtil.splitPath((String)"25");
        Assertions.assertThat((int[])topics).containsExactly(new int[]{25});
    }

    @Test
    public void testTopic() {
        int[] topics = UrlUtil.splitPath((String)"2_5");
        Assertions.assertThat((int[])topics).containsExactly(new int[]{2, 5});
    }

    @Test
    public void testNullPath() {
        int[] topics = UrlUtil.splitPath(null);
        org.junit.jupiter.api.Assertions.assertNull((Object)topics);
    }

    @Test
    public void testEmptyPath() {
        int[] topics = UrlUtil.splitPath((String)"");
        org.junit.jupiter.api.Assertions.assertNull((Object)topics);
    }

    @Test
    public void testDoubleUnderscore() {
        int[] topics = UrlUtil.splitPath((String)"1__2");
        Assertions.assertThat((int[])topics).containsExactly(new int[]{1, 2});
    }

    @Test
    public void testMalformedPath() {
        int[] topics = UrlUtil.splitPath((String)"3_A");
        org.junit.jupiter.api.Assertions.assertNull((Object)topics);
    }
}

