/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import org.eclipse.help.internal.util.URLCoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlCoderTest {
    private static final String SPECIAL_CHARACTERS = "!@#$%^&*()_+-={}[]:\";'<>,.?/'";
    private static final String ALPHANUMERIC = "Bxz91r";
    private static final String ALPHA = "acgrdft";
    private static final String EMPTY_STRING = "";
    private static final String ACCENTED = "seg\u00fan cu\u00e1l oto\u00f1o";
    private static final String CHINESE = "\u4eca\u5929\u662f\u5929";

    private void encodeDecode(String value) {
        String encoded = URLCoder.encode((String)value);
        Assertions.assertEquals((Object)value, (Object)URLCoder.decode((String)encoded));
    }

    private void compactEncodeDecode(String value) {
        String encoded = URLCoder.compactEncode((String)value);
        Assertions.assertEquals((Object)value, (Object)URLCoder.decode((String)encoded));
    }

    private boolean compactEncodingIsShorter(String value) {
        String compactEncoded = URLCoder.compactEncode((String)value);
        String encoded = URLCoder.encode((String)value);
        return compactEncoded.length() < encoded.length();
    }

    @Test
    public void testEncodeEmpty() {
        this.encodeDecode(EMPTY_STRING);
    }

    @Test
    public void testEncodeAlphabetic() {
        this.encodeDecode(ALPHA);
    }

    @Test
    public void testEncodeAlphaNumeric() {
        this.encodeDecode(ALPHANUMERIC);
    }

    @Test
    public void testEncodeSpecialCharacters() {
        this.encodeDecode(SPECIAL_CHARACTERS);
    }

    @Test
    public void testEncodeAccented() {
        this.encodeDecode(ACCENTED);
    }

    @Test
    public void testEncodeChinese() {
        this.encodeDecode(CHINESE);
    }

    @Test
    public void testCompactEncodeEmpty() {
        this.compactEncodeDecode(EMPTY_STRING);
    }

    @Test
    public void testCompactEncodeAlphabetic() {
        this.compactEncodeDecode(ALPHA);
    }

    @Test
    public void testCompactEncodeAlphaNumeric() {
        this.compactEncodeDecode(ALPHANUMERIC);
    }

    @Test
    public void testCompactEncodeSpecialCharacters() {
        this.compactEncodeDecode(SPECIAL_CHARACTERS);
    }

    @Test
    public void testCompactEncodeAccented() {
        this.compactEncodeDecode(ACCENTED);
    }

    @Test
    public void testCompactEncodeChinese() {
        this.compactEncodeDecode(CHINESE);
    }

    @Test
    public void testCompactionEmpty() {
        Assertions.assertFalse((boolean)this.compactEncodingIsShorter(EMPTY_STRING));
    }

    @Test
    public void testCompactionAlphabetic() {
        Assertions.assertTrue((boolean)this.compactEncodingIsShorter(ALPHA));
    }

    @Test
    public void testCompactionAlphaNumeric() {
        Assertions.assertTrue((boolean)this.compactEncodingIsShorter(ALPHANUMERIC));
    }

    @Test
    public void testCompactionSpecialCharacters() {
        Assertions.assertTrue((boolean)this.compactEncodingIsShorter(SPECIAL_CHARACTERS));
    }

    @Test
    public void testCompactionAccented() {
        Assertions.assertTrue((boolean)this.compactEncodingIsShorter(ACCENTED));
    }

    @Test
    public void testCompactionChinese() {
        Assertions.assertFalse((boolean)this.compactEncodingIsShorter(CHINESE));
    }
}

