/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp;

import javax.servlet.http.HttpServletRequest;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.ua.tests.help.webapp.MockServletRequest;
import org.junit.jupiter.api.Test;

public class UrlUtilsTests {
    @Test
    public void testHelpNav() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)UrlUtil.isNavPath((String)"/help/nav/1_2"));
    }

    @Test
    public void testOtherNav() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)UrlUtil.isNavPath((String)"/other/nav/1_2"));
    }

    @Test
    public void testHelpHelpNav() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)UrlUtil.isNavPath((String)"/help/help/nav/1_2"));
    }

    @Test
    public void testNoNav() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)UrlUtil.isNavPath((String)"/helpcontext"));
    }

    @Test
    public void testNoSlash() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)UrlUtil.isNavPath((String)"help/nav/1_2"));
    }

    @Test
    public void testNavTopicPath() {
        int[] path = UrlUtil.getTopicPath((String)"/nav/23_4_5", (String)"en_us");
        Assertions.assertThat((int[])path).containsExactly(new int[]{23, 4, 5});
    }

    @Test
    public void testRelativePathUnrelated() {
        MockServletRequest req = new MockServletRequest();
        req.setPathInfo("/advanced/index.jsp");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../basic/index.jsp", (Object)UrlUtil.getRelativePath((HttpServletRequest)req, (String)"/basic/index.jsp"));
    }

    @Test
    public void testRelativePathSameStart() {
        MockServletRequest req = new MockServletRequest();
        req.setPathInfo("/advanced/index.jsp");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test.jsp", (Object)UrlUtil.getRelativePath((HttpServletRequest)req, (String)"/advanced/test.jsp"));
    }

    @Test
    public void testRelativePathSameFile() {
        MockServletRequest req = new MockServletRequest();
        req.setPathInfo("/advanced/index.jsp");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"index.jsp", (Object)UrlUtil.getRelativePath((HttpServletRequest)req, (String)"/advanced/index.jsp"));
    }

    @Test
    public void testRelativeAlmostMatch1() {
        MockServletRequest req = new MockServletRequest();
        req.setPathInfo("/advanced/index.jsp");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../advance/index.jsp", (Object)UrlUtil.getRelativePath((HttpServletRequest)req, (String)"/advance/index.jsp"));
    }

    @Test
    public void testRelativeAlmostMatch2() {
        MockServletRequest req = new MockServletRequest();
        req.setPathInfo("/advanced/index.jsp");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../advancedd/index.jsp", (Object)UrlUtil.getRelativePath((HttpServletRequest)req, (String)"/advancedd/index.jsp"));
    }

    @Test
    public void testRelativePathMultipleMatchingSegments() {
        MockServletRequest req = new MockServletRequest();
        req.setPathInfo("/a/b/c/index.jsp");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../d/test.jsp", (Object)UrlUtil.getRelativePath((HttpServletRequest)req, (String)"/a/b/d/test.jsp"));
    }

    @Test
    public void testRelativePathSecondSegmentMatch1() {
        MockServletRequest req = new MockServletRequest();
        req.setPathInfo("/a/a/a/index.jsp");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../../../b/a/c/test.jsp", (Object)UrlUtil.getRelativePath((HttpServletRequest)req, (String)"/b/a/c/test.jsp"));
    }

    @Test
    public void testRelativePathSecondSegmentMatch2() {
        MockServletRequest req = new MockServletRequest();
        req.setPathInfo("/b/a/c/index.jsp");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../../../a/a/a/test.jsp", (Object)UrlUtil.getRelativePath((HttpServletRequest)req, (String)"/a/a/a/test.jsp"));
    }

    @Test
    public void testGetHelpUrlNull() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"about:blank", (Object)UrlUtil.getHelpURL(null));
    }

    @Test
    public void testGetHelpUrlHttp() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://www.eclipse.org", (Object)UrlUtil.getHelpURL((String)"http://www.eclipse.org"));
    }

    @Test
    public void testGetHelpUrlHttps() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://bugs.eclipse.org/bugs/", (Object)UrlUtil.getHelpURL((String)"https://bugs.eclipse.org/bugs/"));
    }

    @Test
    public void testGetHelpUrlFile() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../topic/file://etc/about.html", (Object)UrlUtil.getHelpURL((String)"file://etc/about.html"));
    }

    @Test
    public void testGetHelpUrlPageInBundle() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../topic/bundle/help.html", (Object)UrlUtil.getHelpURL((String)"/bundle/help.html"));
    }

    @Test
    public void testGetHelpUrlNullDepthTwo() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"about:blank", (Object)UrlUtil.getHelpURL(null, (int)2));
    }

    @Test
    public void testGetHelpUrlHttpDepthTwo() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://www.eclipse.org", (Object)UrlUtil.getHelpURL((String)"http://www.eclipse.org", (int)2));
    }

    @Test
    public void testGetHelpUrlHttpDepthTwos() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"https://bugs.eclipse.org/bugs/", (Object)UrlUtil.getHelpURL((String)"https://bugs.eclipse.org/bugs/", (int)2));
    }

    @Test
    public void testGetHelpUrlFileDepthTwo() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../../topic/file://etc/about.html", (Object)UrlUtil.getHelpURL((String)"file://etc/about.html", (int)2));
    }

    @Test
    public void testGetHelpUrlPageInBundleDepthTwo() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"../../topic/bundle/help.html", (Object)UrlUtil.getHelpURL((String)"/bundle/help.html", (int)2));
    }
}

