/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp.service;

import java.io.IOException;
import org.eclipse.ua.tests.help.remote.ContentServletTest;
import org.eclipse.ua.tests.help.webapp.service.ServicesTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContentServiceTest
extends ContentServletTest {
    private static final String UA_TESTS = "org.eclipse.ua.tests";

    @Override
    @Test
    public void testSimpleContent() throws Exception {
        String path = "/data/help/index/topic1.html";
        String remoteContent = ServicesTestUtils.getRemoteContent(UA_TESTS, "/data/help/index/topic1.html", "en");
        String localContent = ServicesTestUtils.getLocalContent(UA_TESTS, "/data/help/index/topic1.html");
        Assertions.assertEquals((Object)remoteContent, (Object)localContent);
    }

    @Override
    @Test
    public void testFilteredContent() throws Exception {
        String path = "/data/help/manual/filter.xhtml";
        String remoteContent = ServicesTestUtils.getRemoteContent(UA_TESTS, "/data/help/manual/filter.xhtml", "en");
        String localContent = ServicesTestUtils.getLocalContent(UA_TESTS, "/data/help/manual/filter.xhtml");
        Assertions.assertEquals((Object)remoteContent, (Object)localContent);
    }

    @Override
    @Test
    public void testContentInEnLocale() throws Exception {
        String path = "/data/help/search/testnl1.xhtml";
        String remoteContent = ServicesTestUtils.getRemoteContent(UA_TESTS, "/data/help/search/testnl1.xhtml", "en");
        String localContent = ServicesTestUtils.getLocalContent(UA_TESTS, "/data/help/search/testnl1.xhtml");
        Assertions.assertEquals((Object)remoteContent, (Object)localContent);
    }

    @Override
    @Test
    public void testContentInDeLocale() throws Exception {
        String path = "/data/help/search/testnl1.xhtml";
        String remoteContent = ServicesTestUtils.getRemoteContent(UA_TESTS, "/data/help/search/testnl1.xhtml", "de");
        String enLocalContent = ServicesTestUtils.getLocalContent(UA_TESTS, "/data/help/search/testnl1.xhtml");
        String deLocalContent = ServicesTestUtils.getLocalContent(UA_TESTS, "/nl/de/data/help/search/testnl1.xhtml");
        Assertions.assertEquals((Object)remoteContent, (Object)deLocalContent);
        Assertions.assertFalse((boolean)remoteContent.equals(enLocalContent));
    }

    @Override
    @Test
    public void testRemoteContentNotFound() throws Exception {
        Assertions.assertThrows(IOException.class, () -> {
            String string = ServicesTestUtils.getRemoteContent(UA_TESTS, "/no/such/path.html", "en");
        });
    }
}

