/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp.service;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.ua.tests.help.webapp.service.SchemaValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ExtensionServiceTest {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testExtensionServiceContributionExactMatch1() throws Exception {
        Node root = this.getContentExtensions("en");
        Object[] UARoot = this.findContributionByContent(root, "/org.eclipse.ua.tests/data/help/dynamic/shared/doc2.xml#element.1");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testExtensionServiceContributionExactMatch3() throws Exception {
        Node root = this.getContentExtensions("en");
        Object[] UARoot = this.findContributionByContent(root, "/org.eclipse.ua.tests/data/help/dynamic/shared/doc2.xml#element.3");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testExtensionServiceContributionNoMatch() throws Exception {
        Node root = this.getContentExtensions("en");
        Object[] UARoot = this.findContributionByContent(root, "/org.eclipse.ua.tests/data/help/dynamic/shared/doc2.xml#element.4");
        Assertions.assertThat((Object[])UARoot).isEmpty();
    }

    @Test
    public void testExtensionServiceContributionByPath() throws Exception {
        Node root = this.getContentExtensions("en");
        Object[] UARoot = this.findContributionByPath(root, "/org.eclipse.ua.tests/data/help/dynamic/extension.xml#anchor.invalidcontribution");
        Assertions.assertThat((Object[])UARoot).hasSize(2);
    }

    @Test
    public void testExtensionServiceReplacementExactMatch() throws Exception {
        Node root = this.getContentExtensions("en");
        Object[] UARoot = this.findReplacementByContent(root, "/org.eclipse.ua.tests/data/help/dynamic/shared/doc2.xml#element.1");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testExtensionServiceReplacementNoMatch() throws Exception {
        Node root = this.getContentExtensions("en");
        Object[] UARoot = this.findReplacementByContent(root, "/org.eclipse.ua.tests/data/help/dynamic/shared/doc2.xml#element.3");
        Assertions.assertThat((Object[])UARoot).isEmpty();
    }

    @Test
    public void testExtensionServiceReplacementByPath() throws Exception {
        Node root = this.getContentExtensions("en");
        Object[] UARoot = this.findReplacementByPath(root, "/org.eclipse.ua.tests/data/help/dynamic/shared/doc1.xml#element.2");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    private Element[] findContributionByContent(Node root, String content) {
        return this.findChildren(root, "contribution", "content", content);
    }

    private Element[] findContributionByPath(Node root, String path) {
        return this.findChildren(root, "contribution", "path", path);
    }

    private Element[] findReplacementByContent(Node root, String content) {
        return this.findChildren(root, "replacement", "content", content);
    }

    private Element[] findReplacementByPath(Node root, String path) {
        return this.findChildren(root, "replacement", "path", path);
    }

    private Element[] findChildren(Node parent, String childKind, String attributeName, String attributeValue) {
        NodeList contributions = parent.getChildNodes();
        ArrayList<Node> results = new ArrayList<Node>();
        int i = 0;
        while (i < contributions.getLength()) {
            Element nextElement;
            Node next = contributions.item(i);
            if (next instanceof Element && childKind.equals((nextElement = (Element)next).getTagName()) && attributeValue.equals(nextElement.getAttribute(attributeName))) {
                results.add(next);
            }
            ++i;
        }
        return results.toArray(new Element[results.size()]);
    }

    private Node getContentExtensions(String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/extension?lang=" + locale);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = url.openStream();){
            InputSource inputSource = new InputSource(is);
            Document document = LocalEntityResolver.parse((InputSource)inputSource);
            Node root = document.getFirstChild();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"contentExtensions", (Object)root.getNodeName());
            return root;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testExtensionFragmentServiceXMLSchema() throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/extension?lang=en");
        URL schemaUrl = new URL("http", "localhost", port, "/help/test/schema/xml/extension.xsd");
        String schema = schemaUrl.toString();
        String uri = url.toString();
        String result = SchemaValidator.testXMLSchema(uri, schema);
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("URL: " + uri, new Object[0])).isEqualTo("valid");
    }

    @Test
    public void testExtensionFragmentServiceJSONSchema() throws Exception {
    }
}

