/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp.service;

import java.io.InputStream;
import java.net.URL;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.ua.tests.help.webapp.service.SchemaValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class IndexFragmentServiceTest {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testIndexServletEn() throws Exception {
        this.getTreeData("en");
    }

    @Test
    public void testIndexServletDe() throws Exception {
        this.getTreeData("de");
    }

    private void getTreeData(String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/indexfragment?lang=" + locale);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = url.openStream();){
            InputSource inputSource = new InputSource(is);
            Document document = LocalEntityResolver.parse((InputSource)inputSource);
            Node root = document.getFirstChild();
            Assertions.assertThat((String)root.getNodeName()).isEqualTo("tree_data");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testIndexFragmentServiceXMLSchema() throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/indexfragment?lang=en");
        URL schemaUrl = new URL("http", "localhost", port, "/help/test/schema/xml/indexfragment.xsd");
        String schema = schemaUrl.toString();
        String uri = url.toString();
        String result = SchemaValidator.testXMLSchema(uri, schema);
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("URL: " + uri, new Object[0])).isEqualTo("valid");
    }

    @Test
    public void testIndexFragmentServiceJSONSchema() throws Exception {
    }
}

