/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp.service;

import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.ua.tests.help.remote.SearchServletTest;
import org.eclipse.ua.tests.help.webapp.service.SchemaValidator;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Node;

public class SearchServiceTest
extends SearchServletTest {
    @Override
    protected Node[] getSearchHitsFromServlet(String phrase) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/search?phrase=" + URLEncoder.encode(phrase, StandardCharsets.UTF_8));
        return this.makeServletCall(url);
    }

    @Override
    protected Node[] getSearchHitsUsingLocale(String phrase, String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/search?phrase=" + URLEncoder.encode(phrase, StandardCharsets.UTF_8) + "&lang=" + locale);
        return this.makeServletCall(url);
    }

    @Test
    public void testRemoteSearchXMLSchema() throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/search?phrase=" + URLEncoder.encode("jehcyqpfjs vkrhjewiwh", StandardCharsets.UTF_8));
        URL schemaUrl = new URL("http", "localhost", port, "/help/test/schema/xml/search.xsd");
        String schema = schemaUrl.toString();
        String uri = url.toString();
        String result = SchemaValidator.testXMLSchema(uri, schema);
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("URL: " + uri, new Object[0])).isEqualTo("valid");
    }

    @Test
    public void testRemoteSearchXMLSchemaExactMatchFound() throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/search?phrase=" + URLEncoder.encode("\"jehcyqpfjs vkrhjewiwh\"", StandardCharsets.UTF_8));
        URL schemaUrl = new URL("http", "localhost", port, "/help/test/schema/xml/search.xsd");
        String schema = schemaUrl.toString();
        String uri = url.toString();
        String result = SchemaValidator.testXMLSchema(uri, schema);
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("URL: " + uri, new Object[0])).isEqualTo("valid");
    }

    @Test
    public void testRemoteSearchJSONSchema() throws Exception {
    }
}

