/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp.service;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.ua.tests.help.webapp.service.SchemaValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TocFragmentServiceTest {
    private int mode;

    @BeforeEach
    public void setUp() throws Exception {
        BaseHelpSystem.ensureWebappRunning();
        this.mode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
    }

    @AfterEach
    public void tearDown() throws Exception {
        BaseHelpSystem.setMode((int)this.mode);
    }

    @Test
    public void testTocFragmentServiceContainsUAToc() throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/tocfragment?lang=en");
        Node root = this.getTreeData(url);
        Object[] UARoot = this.findNodeById(root, "/org.eclipse.ua.tests/data/help/toc/root.xml");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
    }

    @Test
    public void testTocFragmentServiceContainsFilteredToc() throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/tocfragment?lang=en&toc=/org.eclipse.ua.tests/data/help/toc/root.xml&path=2");
        Node root = this.getTreeData(url);
        Object[] UARoot = this.findNodeById(root, "/org.eclipse.ua.tests/data/help/toc/root.xml");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
        Object[] filterNode = this.findNodeById((Node)UARoot[0], "2");
        Assertions.assertThat((Object[])filterNode).hasSize(1);
        Object[] results = this.findHref((Node)filterNode[0], "node", "../topic/org.eclipse.ua.tests/data/help/toc/filteredToc/simple_page.html");
        Assertions.assertThat((Object[])results).hasSize(24);
        results = this.findHref((Node)filterNode[0], "node", "../topic/org.eclipse.ua.tests/data/help/toc/filteredToc/helpInstalled.html");
        Assertions.assertThat((Object[])results).hasSize(1);
    }

    @Test
    public void testTocFragmentServiceReadEnToc() throws Exception {
        int uaSearch = this.findUATopicIndex("search", "en");
        org.junit.jupiter.api.Assertions.assertTrue((uaSearch >= 0 ? 1 : 0) != 0);
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/tocfragment?lang=en&toc=/org.eclipse.ua.tests/data/help/toc/root.xml&path=" + uaSearch);
        Node root = this.getTreeData(url);
        Object[] UARoot = this.findNodeById(root, "/org.eclipse.ua.tests/data/help/toc/root.xml");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
        Object[] searchNode = this.findChildren((Node)UARoot[0], "node", "title", "search");
        Assertions.assertThat((Object[])searchNode).hasSize(1);
        Object[] topicEn = this.findHref((Node)searchNode[0], "node", "../topic/org.eclipse.ua.tests/data/help/search/test_en.html");
        Assertions.assertThat((Object[])topicEn).hasSize(1);
        Object[] topicDe = this.findHref((Node)searchNode[0], "node", "../topic/org.eclipse.ua.tests/data/help/search/test_de.html");
        Assertions.assertThat((Object[])topicDe).isEmpty();
    }

    private int findUATopicIndex(String title, String locale) {
        Toc[] tocs;
        int index = -1;
        Toc[] tocArray = tocs = HelpPlugin.getTocManager().getTocs(locale);
        int n = tocs.length;
        int n2 = 0;
        while (n2 < n) {
            Toc toc = tocArray[n2];
            if ("/org.eclipse.ua.tests/data/help/toc/root.xml".equals(toc.getHref())) {
                ITopic[] topics = toc.getTopics();
                int j = 0;
                while (j < topics.length) {
                    if (title.equals(topics[j].getLabel())) {
                        index = j;
                    }
                    ++j;
                }
            }
            ++n2;
        }
        return index;
    }

    @Test
    public void testTocFragmentServiceReadDeToc() throws Exception {
        int helpMode = BaseHelpSystem.getMode();
        BaseHelpSystem.setMode((int)1);
        int uaSearch = this.findUATopicIndex("search", "de");
        org.junit.jupiter.api.Assertions.assertTrue((uaSearch >= 0 ? 1 : 0) != 0);
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/tocfragment?lang=de&toc=/org.eclipse.ua.tests/data/help/toc/root.xml&path=" + uaSearch);
        Node root = this.getTreeData(url);
        Object[] UARoot = this.findNodeById(root, "/org.eclipse.ua.tests/data/help/toc/root.xml");
        Assertions.assertThat((Object[])UARoot).hasSize(1);
        Element[] searchNode = this.findChildren((Node)UARoot[0], "node", "title", "search");
        Object[] topicEn = this.findHref(searchNode[0], "node", "../topic/org.eclipse.ua.tests/data/help/search/test_en.html");
        Assertions.assertThat((Object[])topicEn).isEmpty();
        Object[] topicDe = this.findHref(searchNode[0], "node", "../topic/org.eclipse.ua.tests/data/help/search/test_de.html");
        Assertions.assertThat((Object[])topicDe).hasSize(1);
        BaseHelpSystem.setMode((int)helpMode);
    }

    private Element[] findNodeById(Node root, String id) {
        return this.findChildren(root, "node", "id", id);
    }

    private Element[] findChildren(Node parent, String childKind, String attributeName, String attributeValue) {
        NodeList nodes = parent.getChildNodes();
        ArrayList<Node> results = new ArrayList<Node>();
        int i = 0;
        while (i < nodes.getLength()) {
            Element nextElement;
            Node next = nodes.item(i);
            if (next instanceof Element && childKind.equals((nextElement = (Element)next).getTagName()) && attributeValue.equals(nextElement.getAttribute(attributeName))) {
                results.add(next);
            }
            ++i;
        }
        return results.toArray(new Element[results.size()]);
    }

    private Element[] findHref(Node parent, String childKind, String attributeValue) {
        NodeList nodes = parent.getChildNodes();
        ArrayList<Node> results = new ArrayList<Node>();
        int i = 0;
        while (i < nodes.getLength()) {
            String href;
            Element nextElement;
            Node next = nodes.item(i);
            if (next instanceof Element && childKind.equals((nextElement = (Element)next).getTagName()) && (href = nextElement.getAttribute("href")) != null) {
                int query = href.indexOf(63);
                if (query >= 0) {
                    href = href.substring(0, query);
                }
                if (href.equals(attributeValue)) {
                    results.add(next);
                }
            }
            ++i;
        }
        return results.toArray(new Element[results.size()]);
    }

    private Node getTreeData(URL url) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = url.openStream();){
            InputSource inputSource = new InputSource(is);
            Document document = LocalEntityResolver.parse((InputSource)inputSource);
            Node root = document.getFirstChild();
            org.junit.jupiter.api.Assertions.assertEquals((Object)"tree_data", (Object)root.getNodeName());
            return root;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testTocFragmentServiceXMLSchema() throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/tocfragment?lang=en");
        URL schemaUrl = new URL("http", "localhost", port, "/help/test/schema/xml/tocfragment.xsd");
        String schema = schemaUrl.toString();
        String uri = url.toString();
        String result = SchemaValidator.testXMLSchema(uri, schema);
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("URL: " + uri, new Object[0])).isEqualTo("valid");
    }
}

