/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.help.webapp.service;

import java.io.InputStream;
import java.net.URL;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.ua.tests.help.remote.TocServletTest;
import org.eclipse.ua.tests.help.webapp.service.SchemaValidator;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class TocServiceTest
extends TocServletTest {
    @Override
    protected Node getTocContributions(String locale) throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/toc?lang=" + locale);
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream is = url.openStream();){
            InputSource inputSource = new InputSource(is);
            Document document = LocalEntityResolver.parse((InputSource)inputSource);
            Node root = document.getFirstChild();
            Assertions.assertThat((String)root.getNodeName()).isEqualTo("tocContributions");
            return root;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testTocServiceXMLSchema() throws Exception {
        int port = WebappManager.getPort();
        URL url = new URL("http", "localhost", port, "/help/vs/service/toc?lang=en");
        URL schemaUrl = new URL("http", "localhost", port, "/help/test/schema/xml/toc.xsd");
        String schema = schemaUrl.toString();
        String uri = url.toString();
        String result = SchemaValidator.testXMLSchema(uri, schema);
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("URL: " + uri, new Object[0])).isEqualTo("valid");
    }

    @Test
    public void testTocServiceJSONSchema() throws Exception {
    }
}

