/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.intro.anchors;

import java.util.Vector;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.junit.jupiter.api.Test;

public class ExtensionReorderingTest {
    private IConfigurationElement config;
    private IConfigurationElement[] introConfigExtensions;

    public void readIntroConfig() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = registry.getConfigurationElementsFor("org.eclipse.ui.intro.config");
        this.config = this.getConfigurationFromAttribute(configElements, "introId", "org.eclipse.ua.tests.intro.anchors");
        this.introConfigExtensions = null;
        this.introConfigExtensions = this.getIntroConfigExtensions("configId", "org.eclipse.ua.tests.intro.config.anchors");
    }

    private IConfigurationElement getConfigurationFromAttribute(IConfigurationElement[] configElements, String attributeName, String attributeValue) {
        IConfigurationElement[] filteredConfigElements = this.getConfigurationsFromAttribute(configElements, attributeName, attributeValue);
        IConfigurationElement config = ModelLoaderUtil.validateSingleContribution((IConfigurationElement[])filteredConfigElements, (String)attributeName);
        return config;
    }

    protected IConfigurationElement[] getConfigurationsFromAttribute(IConfigurationElement[] configElements, String attributeName, String attributeValue) {
        Vector<IConfigurationElement> elements = new Vector<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String currentAttributeValue = configElement.getAttribute(attributeName);
            if (currentAttributeValue != null && currentAttributeValue.equals(attributeValue)) {
                elements.add(configElement);
            }
            ++n2;
        }
        Object[] filteredConfigElements = new IConfigurationElement[elements.size()];
        elements.copyInto(filteredConfigElements);
        return filteredConfigElements;
    }

    protected IConfigurationElement[] getIntroConfigExtensions(String attrributeName, String attributeValue) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configExtensionElements = registry.getConfigurationElementsFor("org.eclipse.ui.intro.configExtension");
        IConfigurationElement[] configExtensions = this.getConfigurationsFromAttribute(configExtensionElements, attrributeName, attributeValue);
        return configExtensions;
    }

    @Test
    public void testOrder123456() {
        this.readIntroConfig();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)this.config);
        Assertions.assertThat((Object[])this.introConfigExtensions).hasSize(6);
        IntroModelRoot model = new IntroModelRoot(this.config, this.introConfigExtensions);
        model.loadModel();
        this.checkModel(model, 6);
    }

    private void checkModel(IntroModelRoot model, int elements) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)model.hasValidConfig());
        Object[] pages = model.getChildrenOfType(12);
        AbstractIntroPage root = (AbstractIntroPage)model.findChild("root");
        Assertions.assertThat((Object[])pages).hasSize(elements + 2);
        IntroPage extn1 = (IntroPage)model.findChild("page1");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)extn1);
        AbstractIntroElement p1link = root.findChild("page1link");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)p1link);
        IntroPage extn2 = (IntroPage)model.findChild("page2");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)extn2);
        AbstractIntroElement p2link = root.findChild("page2link");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)p2link);
        IntroPage extn3 = (IntroPage)model.findChild("page3");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)extn3);
        AbstractIntroElement p3link = extn1.findChild("page3link");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)p3link);
        if (elements >= 4) {
            IntroPage extn4 = (IntroPage)model.findChild("page4");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)extn4);
            AbstractIntroElement p4link = extn2.findChild("page4link");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)p4link);
            if (elements >= 5) {
                IntroPage extn5 = (IntroPage)model.findChild("page5");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)extn5);
                AbstractIntroElement p5link = extn4.findChild("page5link");
                AbstractIntroElement p5linkR = extn4.findChild("page5linkR");
                if (elements == 5) {
                    org.junit.jupiter.api.Assertions.assertNotNull((Object)p5link);
                    org.junit.jupiter.api.Assertions.assertNull((Object)p5linkR);
                } else {
                    org.junit.jupiter.api.Assertions.assertNull((Object)p5link);
                    org.junit.jupiter.api.Assertions.assertNotNull((Object)p5linkR);
                }
            }
        }
        if (elements >= 6) {
            IntroPage extn6 = (IntroPage)model.findChild("page6");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)extn6);
            extn6.getChildren();
            AbstractIntroElement actionlinks = extn6.findChild("action-links");
            AbstractIntroElement p5linkR = extn6.findChild("page5linkR");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)actionlinks);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)p5linkR);
        }
    }

    @Test
    public void testAllOrdersOf3Contributions() {
        new Permutations().testAll(3);
    }

    @Test
    public void testAllOrdersOf4Contributions() {
        new Permutations().testAll(4);
    }

    @Test
    public void testAllOrdersOf5Contributions() {
        this.readIntroConfig();
        new Permutations().testAll(5);
    }

    @Test
    public void testManyOrdersOf6Contributions() {
        this.readIntroConfig();
        new Permutations(7).testAll(6);
    }

    private class Permutations {
        private int numContributions;
        private int[] order;
        private int cycle = 1;
        private int count = 0;

        public void testAll(int numContributions) {
            this.numContributions = numContributions;
            this.order = new int[numContributions];
            this.tryAll(0);
        }

        public Permutations(int testCycle) {
            this.cycle = testCycle;
        }

        public Permutations() {
        }

        private void tryAll(int next) {
            int value = 0;
            while (value < this.numContributions) {
                this.tryValue(next, value);
                ++value;
            }
        }

        private void tryValue(int next, int value) {
            int pos = 0;
            while (pos < next) {
                if (this.order[pos] == value) {
                    return;
                }
                ++pos;
            }
            this.order[next] = value;
            if (next + 1 == this.numContributions) {
                ++this.count;
                if (this.count % this.cycle == 0) {
                    this.testReordering(this.order);
                    this.count = 0;
                }
            } else {
                this.tryAll(next + 1);
            }
        }

        private String toString(int[] order) {
            Object result = "";
            int[] nArray = order;
            int n = order.length;
            int n2 = 0;
            while (n2 < n) {
                int element = nArray[n2];
                result = (String)result + element;
                ++n2;
            }
            return result;
        }

        private void testReordering(int[] order) {
            ExtensionReorderingTest.this.readIntroConfig();
            IConfigurationElement[] extensions = new IConfigurationElement[this.numContributions];
            int i = 0;
            while (i < this.numContributions) {
                extensions[i] = ExtensionReorderingTest.this.introConfigExtensions[order[i]];
                ++i;
            }
            IntroModelRoot model = new IntroModelRoot(ExtensionReorderingTest.this.config, extensions);
            try {
                model.loadModel();
                Assertions.assertThat((Object)model).matches(IntroModelRoot::hasValidConfig, "Order = " + this.toString(order));
                ExtensionReorderingTest.this.checkModel(model, this.numContributions);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                org.junit.jupiter.api.Assertions.fail((String)("Exception thrown when order was " + this.toString(order)));
            }
        }
    }
}

