/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.intro.contentdetect;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.internal.intro.impl.model.ExtensionMap;
import org.eclipse.ui.internal.intro.universal.contentdetect.ContentDetectHelper;
import org.eclipse.ui.internal.intro.universal.contentdetect.ContentDetector;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class ContentDetectorTest {
    @Test
    public void testContributorCount() {
        ContentDetectHelper helper = new ContentDetectHelper();
        helper.saveExtensionCount(4);
        Assertions.assertEquals((int)4, (int)helper.getExtensionCount());
        Assertions.assertEquals((int)4, (int)helper.getExtensionCount());
        helper.saveExtensionCount(5);
        helper.saveExtensionCount(6);
        Assertions.assertEquals((int)6, (int)helper.getExtensionCount());
    }

    @Test
    public void testContributorSaveNoNames() {
        ContentDetectHelper helper = new ContentDetectHelper();
        helper.saveContributors(new HashSet());
        Assertions.assertTrue((helper.getContributors().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testContributorSaveThreeContributors() {
        ContentDetectHelper helper = new ContentDetectHelper();
        HashSet<String> contributors = new HashSet<String>();
        contributors.add("one");
        contributors.add("two");
        contributors.add("three");
        helper.saveContributors(contributors);
        Set savedContributors = helper.getContributors();
        Assertions.assertTrue((savedContributors.size() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)savedContributors.contains("one"));
        Assertions.assertTrue((boolean)savedContributors.contains("two"));
        Assertions.assertTrue((boolean)savedContributors.contains("three"));
    }

    @Test
    public void testForNewContent() {
        ContentDetectHelper helper = new ContentDetectHelper();
        HashSet<String> contributors = new HashSet<String>();
        contributors.add("one");
        contributors.add("two");
        contributors.add("three");
        contributors.add("four");
        HashSet<String> previous = new HashSet<String>();
        previous.add("five");
        previous.add("two");
        previous.add("one");
        Set newContributors = helper.findNewContributors(contributors, previous);
        Assertions.assertTrue((newContributors.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)newContributors.contains("four"));
        Assertions.assertTrue((boolean)newContributors.contains("three"));
    }

    @Test
    public void testNoSavedState() {
        ContentDetectHelper helper = new ContentDetectHelper();
        helper.deleteStateFiles();
        Assertions.assertTrue((boolean)helper.getContributors().isEmpty());
        Assertions.assertEquals((int)-1, (int)helper.getExtensionCount());
        ContentDetector detector = new ContentDetector();
        Assertions.assertFalse((boolean)detector.isNewContentAvailable());
        Set newContent = ContentDetector.getNewContributors();
        Assertions.assertTrue((newContent == null || newContent.isEmpty() ? 1 : 0) != 0);
        String firstContribution = (String)helper.getContributors().iterator().next();
        Assertions.assertFalse((boolean)ContentDetector.isNew((String)firstContribution));
    }

    @Test
    public void testStateChanges() {
        ContentDetectHelper helper = new ContentDetectHelper();
        helper.deleteStateFiles();
        ContentDetector detector = new ContentDetector();
        Assertions.assertFalse((boolean)detector.isNewContentAvailable());
        int extensionCount = helper.getExtensionCount();
        Assertions.assertTrue((extensionCount > 0 ? 1 : 0) != 0);
        helper.saveExtensionCount(extensionCount + 1);
        Assertions.assertFalse((boolean)detector.isNewContentAvailable());
        helper.saveExtensionCount(extensionCount - 1);
        Set contributors = helper.getContributors();
        String firstContribution = (String)contributors.iterator().next();
        String copyOfFirstContribution = firstContribution;
        contributors.remove(firstContribution);
        helper.saveContributors(contributors);
        Assertions.assertTrue((boolean)detector.isNewContentAvailable());
        Assertions.assertEquals((int)1, (int)ContentDetector.getNewContributors().size());
        Assertions.assertTrue((boolean)ContentDetector.isNew((String)firstContribution));
        Assertions.assertTrue((boolean)ContentDetector.isNew((String)copyOfFirstContribution));
        ContentDetector detector2 = new ContentDetector();
        Assertions.assertTrue((boolean)detector2.isNewContentAvailable());
        Assertions.assertEquals((int)1, (int)ContentDetector.getNewContributors().size());
        Assertions.assertTrue((boolean)ContentDetector.isNew((String)firstContribution));
        Assertions.assertTrue((boolean)ContentDetector.isNew((String)copyOfFirstContribution));
    }

    @Test
    public void testExtensionMapSingleton() {
        ExtensionMap map1 = ExtensionMap.getInstance();
        ExtensionMap map2 = ExtensionMap.getInstance();
        Assertions.assertEquals((Object)map1, (Object)map2);
    }

    @Test
    public void testExtensionMapping() {
        ExtensionMap map = ExtensionMap.getInstance();
        map.clear();
        map.putPluginId("anchor1", "org.eclipse.test");
        map.putPluginId("anchor2", "org.eclipse.test");
        map.putPluginId("anchor3", "org.eclipse.test3");
        Assertions.assertEquals((Object)"org.eclipse.test", (Object)map.getPluginId("anchor1"));
        Assertions.assertEquals((Object)"org.eclipse.test", (Object)map.getPluginId("anchor2"));
        Assertions.assertEquals((Object)"org.eclipse.test3", (Object)map.getPluginId("anchor3"));
        map.clear();
        Assertions.assertNull((Object)map.getPluginId("anchor1"));
    }

    @Test
    public void testStartPage() {
        ExtensionMap map = ExtensionMap.getInstance();
        map.setStartPage("tutorials");
        map.setStartPage("whats-new");
        Assertions.assertEquals((Object)"whats-new", (Object)map.getStartPage());
        map.clear();
        Assertions.assertNull((Object)map.getStartPage());
    }

    @AfterAll
    public static void cleanup() throws Throwable {
        ContentDetectHelper helper = new ContentDetectHelper();
        helper.deleteStateFiles();
    }
}

