/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.intro.other;

import org.eclipse.ui.internal.intro.impl.util.StringUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NormalizeWhitespaceTest {
    @Test
    public void testNullString() {
        Assertions.assertNull((Object)StringUtil.normalizeWhiteSpace(null));
    }

    @Test
    public void testEmptyString() {
        String result = StringUtil.normalizeWhiteSpace((String)"");
        Assertions.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testSimpleString() {
        String result = StringUtil.normalizeWhiteSpace((String)"Hello World");
        Assertions.assertEquals((Object)"Hello World", (Object)result);
    }

    @Test
    public void testRepeatedSpace() {
        String result = StringUtil.normalizeWhiteSpace((String)"Hello   World");
        Assertions.assertEquals((Object)"Hello World", (Object)result);
    }

    @Test
    public void testOtherWhitespace() {
        String result = StringUtil.normalizeWhiteSpace((String)"Hello\n\r\t World");
        Assertions.assertEquals((Object)"Hello World", (Object)result);
    }

    @Test
    public void testLeadingSpace() {
        String result = StringUtil.normalizeWhiteSpace((String)" Hello World");
        Assertions.assertEquals((Object)"Hello World", (Object)result);
    }

    @Test
    public void testTrailingSpace() {
        String result = StringUtil.normalizeWhiteSpace((String)"Hello World ");
        Assertions.assertEquals((Object)"Hello World", (Object)result);
    }
}

