/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.intro.parser;

import java.io.IOException;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.ua.tests.intro.util.IntroModelSerializer;
import org.eclipse.ua.tests.intro.util.IntroModelSerializerTest;
import org.eclipse.ua.tests.util.FileUtil;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ValidTest {
    @BeforeEach
    public void setUp() throws Exception {
        HelpUIPlugin.getDefault();
    }

    @Test
    public void testDynamicXHTML() throws IOException {
        this.singleConfigTest("org.eclipse.ua.tests.intro.config.dynamicXHTML");
    }

    @Test
    public void testDynamicXML() throws IOException {
        this.singleConfigTest("org.eclipse.ua.tests.intro.config.dynamicXML");
    }

    @Test
    public void testAnchors() throws IOException {
        this.singleConfigTest("org.eclipse.ua.tests.intro.config.anchors");
    }

    @Test
    public void testMixed() throws IOException {
        this.singleConfigTest("org.eclipse.ua.tests.intro.config.mixed");
    }

    @Test
    public void testStatic() throws IOException {
        this.singleConfigTest("org.eclipse.ua.tests.intro.config.static");
    }

    private void singleConfigTest(String configId) throws IOException {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.config");
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getDeclaringExtension().getContributor().getName().equals(bundle.getSymbolicName())) {
                String content = element.getAttribute("content");
                String id = element.getAttribute("id");
                if (id.equals(configId)) {
                    int x = 0;
                    while (x < 10) {
                        IntroModelRoot model = ExtensionPointManager.getInst().getModel(id);
                        IntroModelSerializer serializer = new IntroModelSerializer(model);
                        String expected = FileUtil.getContents(bundle, FileUtil.getResultFile(content));
                        String actual = serializer.toString();
                        ((AbstractStringAssert)Assertions.assertThat((String)actual).as("the model parsed for intro did not match the expected result for: " + id, new Object[0])).isEqualTo(expected);
                        Map<String, String> map = IntroModelSerializerTest.getXHTMLFiles(model);
                        for (Map.Entry<String, String> entry : map.entrySet()) {
                            String relativePath = entry.getKey();
                            expected = FileUtil.getContents(bundle, FileUtil.getResultFile(relativePath));
                            actual = entry.getValue();
                            ((AbstractStringAssert)Assertions.assertThat((String)actual).as("the XHTML generated for intro did not match the expected result for: " + relativePath, new Object[0])).isEqualTo(expected);
                        }
                        ++x;
                    }
                    return;
                }
            }
            ++n2;
        }
        org.junit.jupiter.api.Assertions.fail((String)"Config extension not found");
    }
}

