/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.intro.performance;

import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCaseJunit5;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.CustomizableIntroPart;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.osgi.framework.FrameworkUtil;

@Disabled(value="Disabled due to inability to backport test to 3.2. Internal test hooks were added in 3.2.2 code base but do not exist in 3.2 so the test will not be accurate.")
public class OpenIntroTest
extends PerformanceTestCaseJunit5 {
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        super.setUp(testInfo);
        OpenIntroTest.closeIntro();
        System.setProperty("org.eclipse.ua.tests.property.isTesting", "true");
        ExtensionPointManager.getInst().setExtensionFilter(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName());
    }

    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        OpenIntroTest.closeIntro();
        System.setProperty("org.eclipse.ua.tests.property.isTesting", "false");
        ExtensionPointManager.getInst().setExtensionFilter(null);
    }

    @Test
    public void testOpenIntro() throws Exception {
        this.tagAsSummary("Open welcome", Dimension.ELAPSED_PROCESS);
        int i = 0;
        while (i < 3) {
            OpenIntroTest.openIntro();
            OpenIntroTest.closeIntro();
            ++i;
        }
        i = 0;
        while (i < 50) {
            this.startMeasuring();
            OpenIntroTest.openIntro();
            this.stopMeasuring();
            OpenIntroTest.closeIntro();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public static void closeIntro() throws Exception {
        IIntroManager manager = PlatformUI.getWorkbench().getIntroManager();
        IIntroPart part = manager.getIntro();
        if (part != null) {
            manager.closeIntro(part);
        }
        ExtensionPointManager.getInst().clear();
        OpenIntroTest.flush();
    }

    private static void openIntro() throws Exception {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IIntroManager manager = workbench.getIntroManager();
        CustomizableIntroPart introPart = (CustomizableIntroPart)manager.showIntro(workbench.getActiveWorkbenchWindow(), false);
        Display display = Display.getDefault();
        while (!introPart.internal_isFinishedLoading()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        OpenIntroTest.flush();
    }

    private static void flush() {
        Display display = Display.getCurrent();
        while (display.readAndDispatch()) {
        }
    }
}

