/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.intro.util;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroAnchor;
import org.eclipse.ui.internal.intro.impl.model.IntroContentProvider;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHTML;
import org.eclipse.ui.internal.intro.impl.model.IntroHead;
import org.eclipse.ui.internal.intro.impl.model.IntroHomePage;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroInclude;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.osgi.framework.Bundle;

public class IntroModelSerializer {
    private final StringBuilder buffer = new StringBuilder();

    public IntroModelSerializer(IntroModelRoot root) {
        this.printModelRootInfo(root, this.buffer);
        IntroHomePage rootPage = root.getRootPage();
        this.printHomePage((AbstractIntroPage)rootPage, this.buffer);
        this.printPageChildren((AbstractIntroPage)rootPage, this.buffer);
        IntroPage[] pages = root.getPages();
        this.printPages(pages, this.buffer);
        this.buffer.append("\n\n");
        this.printModelFlagTests(root, this.buffer);
    }

    private String filterURL(String url) {
        if (url != null && url.startsWith("file:/")) {
            return "file:/<filtered>" + url.substring(url.lastIndexOf(47));
        }
        return url;
    }

    private void printModelRootInfo(IntroModelRoot model, StringBuilder text) {
        text.append("Intro Model Content:");
        text.append("\n======================");
        text.append("\n\nModel has valid config = " + model.hasValidConfig());
        text.append("\nPresentation type = " + model.getPresentation().getType());
        text.append("\nHome page id = " + model.getPresentation().getHomePageId());
        IntroHead headContent = model.getPresentation().getHead();
        if (headContent != null) {
            text.append("\nPresentation Shared Head = " + headContent.getSrc());
        }
        text.append("\nNumber of pages (not including Root Page) = " + model.getPages().length);
        text.append("\nNumber of shared groups = " + model.getChildrenOfType(16).length);
        text.append("\nNumber of unresolved extensions = " + model.getChildrenOfType(1024).length);
    }

    private void printHomePage(AbstractIntroPage rootPage, StringBuilder text) {
        text.append("\n\nHOME PAGE: ");
        text.append("\n--------------");
        text.append("\n\tis dynamic= " + ((IntroModelRoot)rootPage.getParent()).isDynamic());
        text.append("\n\tid = " + rootPage.getId());
        text.append("\n\ttitle = " + rootPage.getTitle());
        text.append("\n\tstyle = " + this.filterURL(rootPage.getStyle()));
        text.append("\n\talt-style = " + this.filterURL(rootPage.getAltStyle()));
        text.append("\n\turl = " + this.filterURL(rootPage.getUrl()));
        text.append("\n\tstyle-id = " + rootPage.getStyleId());
        this.printPageStyles(rootPage, text);
    }

    private void printPageStyles(AbstractIntroPage page, StringBuilder text) {
        String[] styles;
        text.append("\n\tpage styles are = ");
        String[] stringArray = styles = page.getStyles();
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            String style = stringArray[n2];
            text.append(this.filterURL(style + "\n\t\t\t"));
            ++n2;
        }
        text.append("\n\tpage alt-styles are = ");
        Map altStylesHashtable = page.getAltStyles();
        if (altStylesHashtable == null) {
            return;
        }
        Set set = altStylesHashtable.keySet();
        Object[] sorted = new String[set.size()];
        set.toArray(sorted);
        int i = 0;
        while (i < sorted.length) {
            Bundle bundle = (Bundle)altStylesHashtable.get(sorted[i]);
            sorted[i] = this.filterURL((String)sorted[i]) + " from " + bundle.getSymbolicName();
            ++i;
        }
        Arrays.sort(sorted);
        Object[] objectArray = sorted;
        int n3 = sorted.length;
        int n4 = 0;
        while (n4 < n3) {
            Object element = objectArray[n4];
            text.append((String)element + "\n\t\t");
            ++n4;
        }
    }

    private void printPageChildren(AbstractIntroPage page, StringBuilder text) {
        text.append("\n\tpage children = " + page.getChildren().length);
        text.append("\n");
        this.printContainerChildren((AbstractIntroContainer)page, text, "\n\t\t");
    }

    private void printContainerChildren(AbstractIntroContainer container, StringBuilder text, String indent) {
        AbstractIntroElement[] children;
        AbstractIntroElement[] abstractIntroElementArray = children = container.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractIntroElement element = abstractIntroElementArray[n2];
            int childType = element.getType();
            switch (childType) {
                case 131071: {
                    text.append("SHOULD NEVER BE HERE");
                    break;
                }
                case 16: {
                    this.printGroup(text, (IntroGroup)element, indent);
                    break;
                }
                case 64: {
                    this.printLink(text, (IntroLink)element, indent);
                    break;
                }
                case 512: {
                    this.printText(text, (IntroText)element, indent);
                    break;
                }
                case 128: {
                    this.printImage(text, (IntroImage)element, indent);
                    break;
                }
                case 32: {
                    this.printHtml(text, (IntroHTML)element, indent);
                    break;
                }
                case 256: {
                    this.printInclude(text, (IntroInclude)element, indent);
                    break;
                }
                case 2048: {
                    this.printHead(text, (IntroHead)element, indent);
                    break;
                }
                case 4096: {
                    this.printPageTitle(text, (IntroPageTitle)element, indent);
                    break;
                }
                case 8192: {
                    this.printAnchor(text, (IntroAnchor)element, indent);
                    break;
                }
                case 16384: {
                    this.printContentProvidor(text, (IntroContentProvider)element, indent);
                }
            }
            ++n2;
        }
    }

    private void printGroup(StringBuilder text, IntroGroup group, String indent) {
        text.append((String)indent + "GROUP: id = " + group.getId());
        indent = (String)indent + "\t\t";
        text.append((String)indent + "label = " + group.getLabel());
        text.append((String)indent + "children = " + group.getChildren().length);
        text.append((String)indent + "style-id = " + group.getStyleId());
        this.printContainerChildren((AbstractIntroContainer)group, text, (String)indent + "\t\t");
    }

    private void printLink(StringBuilder text, IntroLink link, String indent) {
        text.append((String)indent + "LINK: id = " + link.getId());
        indent = (String)indent + "\t\t";
        text.append((String)indent + "label = " + link.getLabel());
        text.append((String)indent + "text = " + link.getText());
        text.append((String)indent + "url = " + link.getUrl());
        text.append((String)indent + "style-id = " + link.getStyleId());
    }

    private void printText(StringBuilder text, IntroText introText, String indent) {
        text.append((String)indent + "TEXT: id = " + introText.getId());
        indent = (String)indent + "\t\t";
        text.append((String)indent + "text = " + introText.getText());
        text.append((String)indent + "style-id = " + introText.getStyleId());
    }

    private void printImage(StringBuilder text, IntroImage image, String indent) {
        text.append((String)indent + "IMAGE: id = " + image.getId());
        indent = (String)indent + "\t\t";
        text.append((String)indent + "src = " + image.getSrc());
        text.append((String)indent + "alt = " + image.getAlt());
        text.append((String)indent + "style-id = " + image.getStyleId());
    }

    private void printHtml(StringBuilder text, IntroHTML html, String indent) {
        text.append((String)indent + "HTML: id = " + html.getId());
        indent = (String)indent + "\t\t";
        text.append((String)indent + "src = " + html.getSrc());
        text.append((String)indent + "isInlined = " + html.isInlined());
        text.append((String)indent + "style-id = " + html.getStyleId());
        if (html.getIntroImage() != null) {
            this.printImage(text, html.getIntroImage(), (String)indent + "\t\t");
        }
        if (html.getIntroText() != null) {
            this.printText(text, html.getIntroText(), (String)indent + "\t\t");
        }
    }

    private void printInclude(StringBuilder text, IntroInclude include, String indent) {
        text.append((String)indent + "INCLUDE: configId = " + include.getConfigId());
        indent = (String)indent + "\t\t";
        text.append((String)indent + "path = " + include.getPath());
        text.append((String)indent + "merge-style = " + include.getMergeStyle());
    }

    private void printHead(StringBuilder text, IntroHead head, String indent) {
        text.append(indent + "HEAD: src = " + head.getSrc());
    }

    private void printPageTitle(StringBuilder text, IntroPageTitle title, String indent) {
        text.append((String)indent + "TITLE: id = " + title.getId());
        indent = (String)indent + "\t\t";
        text.append((String)indent + "title = " + title.getTitle());
        text.append((String)indent + "style-id = " + title.getStyleId());
    }

    private void printAnchor(StringBuilder text, IntroAnchor anchor, String indent) {
        text.append(indent + "ANCHOR: id = " + anchor.getId());
    }

    private void printContentProvidor(StringBuilder text, IntroContentProvider provider, String indent) {
        text.append((String)indent + "CONTENT PROVIDER: id = " + provider.getId());
        indent = (String)indent + "\t\t";
        text.append((String)indent + "class = " + provider.getClassName());
        text.append((String)indent + "pluginId = " + provider.getPluginId());
        if (provider.getIntroText() != null) {
            this.printText(text, provider.getIntroText(), (String)indent + "\t\t");
        }
    }

    private void printPages(IntroPage[] pages, StringBuilder text) {
        IntroPage[] introPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IntroPage page = introPageArray[n2];
            text.append("\n\nPAGE id = " + page.getId());
            text.append("\n----------");
            text.append("\n\ttitle = " + page.getTitle());
            text.append("\n\tstyle = " + this.filterURL(page.getStyle()));
            text.append("\n\talt-style = " + this.filterURL(page.getAltStyle()));
            text.append("\n\tstyle-id = " + page.getStyleId());
            this.printPageStyles((AbstractIntroPage)page, text);
            this.printPageChildren((AbstractIntroPage)page, text);
            ++n2;
        }
    }

    private void printModelFlagTests(IntroModelRoot model, StringBuilder text) {
        text.append("Model Flag Tests: ");
        text.append("\n----------------");
        if (model.getPages().length == 0) {
            text.append("\nNo first page in model\n\n");
            return;
        }
        IntroPage firstPage = model.getPages()[0];
        if ("standby".equals(firstPage.getId())) {
            firstPage = model.getPages()[1];
        }
        text.append("\n\t\tFirst page children are: ");
        text.append("\n\t\t\tGroups: " + firstPage.getChildrenOfType(16).length);
        text.append("\n\t\t\tLinks: " + firstPage.getChildrenOfType(64).length);
        text.append("\n\t\t\tTexts: " + firstPage.getChildrenOfType(512).length);
        text.append("\n\t\t\tHTMLs: " + firstPage.getChildrenOfType(32).length);
        text.append("\n\t\t\tImages: " + firstPage.getChildrenOfType(128).length);
        text.append("\n\t\t\tIncludes: " + firstPage.getChildrenOfType(256).length);
        text.append("\n\t\t\tPage Titles: " + firstPage.getChildrenOfType(4096).length);
        text.append("\n\t\t\tPage Heads: " + firstPage.getChildrenOfType(2048).length);
        text.append("\n\t\t\tModel Elements: " + firstPage.getChildrenOfType(131071).length);
        text.append("\n\t\t\tContainers: " + firstPage.getChildrenOfType(29).length);
        text.append("\n\t\t\tAll Pages: " + firstPage.getChildrenOfType(12).length);
        text.append("\n\t\t\tAnchors: " + firstPage.getChildrenOfType(8192).length);
        text.append("\n\t\t\tContent providers: " + firstPage.getChildrenOfType(16384).length);
        text.append("\n\t\t\tElements with Text child(AbstractTextElemets): " + firstPage.getChildrenOfType(16480).length);
        AbstractIntroElement[] linksAndGroups = (AbstractIntroElement[])firstPage.getChildrenOfType(80);
        text.append("\n\t\t\tGroups and Links: " + linksAndGroups.length);
    }

    public String toString() {
        return this.buffer.toString();
    }
}

