/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.intro.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.ua.tests.intro.util.IntroModelSerializer;
import org.eclipse.ua.tests.util.FileUtil;
import org.eclipse.ua.tests.util.XHTMLUtil;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroHomePage;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartImplementation;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class IntroModelSerializerTest {
    @BeforeEach
    public void setUp() throws Exception {
        HelpUIPlugin.getDefault();
    }

    @Test
    public void testRunSerializer() throws FileNotFoundException {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.intro.config");
        Bundle bundle = FrameworkUtil.getBundle(IntroModelSerializerTest.class);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getDeclaringExtension().getContributor().getName().equals(bundle.getSymbolicName())) {
                String pluginRoot = bundle.getLocation().substring("update@".length());
                String content = element.getAttribute("content");
                String id = element.getAttribute("id");
                IntroModelRoot model = ExtensionPointManager.getInst().getModel(id);
                IntroModelSerializer serializer = new IntroModelSerializer(model);
                String file = FileUtil.getResultFile(pluginRoot + content);
                Throwable throwable = null;
                Object var14_15 = null;
                try (PrintWriter out = new PrintWriter(new FileOutputStream(file));){
                    out.print(serializer.toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                Map<String, String> map = IntroModelSerializerTest.getXHTMLFiles(model);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    file = FileUtil.getResultFile(pluginRoot + entry.getKey());
                    Throwable throwable3 = null;
                    Object var17_20 = null;
                    try (PrintWriter out = new PrintWriter(new FileOutputStream(file));){
                        out.print(entry.getValue());
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
            }
            ++n2;
        }
    }

    public static Map<String, String> getXHTMLFiles(IntroModelRoot model) {
        IntroPage[] otherPages;
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<Object> pages = new ArrayList<Object>();
        IntroHomePage home = model.getRootPage();
        if (home.isXHTMLPage()) {
            pages.add(home);
        }
        IntroPage[] introPageArray = otherPages = model.getPages();
        int n = otherPages.length;
        int n2 = 0;
        while (n2 < n) {
            IntroPage introPage = introPageArray[n2];
            if (introPage.isXHTMLPage()) {
                pages.add(introPage);
            }
            ++n2;
        }
        for (AbstractIntroPage abstractIntroPage : pages) {
            BrowserIntroPartImplementation impl = new BrowserIntroPartImplementation();
            String xhtml = impl.generateXHTMLPage(abstractIntroPage, (provider, incremental) -> {});
            xhtml = XHTMLUtil.removeEnvironmentSpecificContent(xhtml);
            xhtml = xhtml.replaceAll("\r", "");
            xhtml = xhtml.trim();
            map.put(abstractIntroPage.getInitialBase() + abstractIntroPage.getRawContent(), xhtml);
        }
        return map;
    }
}

