/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ResourceFinder {
    public static URL findFile(Bundle plugin, String path) {
        return FileLocator.find((Bundle)plugin, (IPath)IPath.fromOSString((String)path), null);
    }

    public static URL[] findFiles(Bundle plugin, String folder, String suffix, boolean recursive) {
        String fullLocation = plugin.getLocation();
        String location = fullLocation.substring(fullLocation.indexOf(64) + 1);
        IPath path = IPath.fromOSString((String)location).append(folder);
        File file = path.toFile();
        if (!file.exists()) {
            URL url = Platform.getInstallLocation().getURL();
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        return ResourceFinder.findFiles(file.listFiles(), suffix, recursive);
    }

    private static URL[] findFiles(File[] files, String suffix, boolean recursive) {
        ArrayList<URL> list = new ArrayList<URL>();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    if (recursive) {
                        list.addAll(Arrays.asList(ResourceFinder.findFiles(file.listFiles(), suffix, recursive)));
                    }
                } else {
                    try {
                        URL url = file.toURI().toURL();
                        if (url.toString().endsWith(suffix)) {
                            list.add(url);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        URL[] array = new URL[list.size()];
        list.toArray(array);
        return array;
    }
}

