/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ua.tests.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtil {
    public static void assertXMLEquals(String msg, String s1, String s2) throws Exception {
        ByteArrayInputStream in1 = new ByteArrayInputStream(s1.getBytes(StandardCharsets.UTF_8));
        ByteArrayInputStream in2 = new ByteArrayInputStream(s2.getBytes(StandardCharsets.UTF_8));
        XMLUtil.assertXMLEquals(msg, in1, in2);
    }

    public static void assertXMLEquals(String msg, InputStream in1, InputStream in2) throws Exception {
        String s1 = XMLUtil.process(in1);
        String s2 = XMLUtil.process(in2);
        ((AbstractStringAssert)Assertions.assertThat((String)s1).as(msg, new Object[0])).isEqualTo(s2);
    }

    public static void assertParseableXML(String s) {
        try {
            ByteArrayInputStream in1 = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
            XMLUtil.process(in1);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)("Unable to parse source: " + s));
        }
    }

    private static String process(InputStream in) throws Exception {
        SAXParser parser = XmlProcessorFactory.createSAXParserNoExternal();
        Handler handler = new Handler();
        parser.parse(in, (DefaultHandler)handler);
        return handler.toString();
    }

    private static class Handler
    extends DefaultHandler {
        private final StringBuilder buf = new StringBuilder();

        private Handler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.buf.append('<');
            this.buf.append(qName);
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < attributes.getLength()) {
                list.add(attributes.getQName(i));
                ++i;
            }
            list.sort(null);
            for (String name : list) {
                this.buf.append(' ');
                this.buf.append(name);
                this.buf.append('=');
                this.buf.append('\"');
                this.buf.append(attributes.getValue(name));
                this.buf.append('\"');
            }
            this.buf.append('>');
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.buf.append('<');
            this.buf.append('/');
            this.buf.append(qName);
            this.buf.append('>');
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buf.append(ch, start, length);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            try {
                return LocalEntityResolver.resolve((String)publicId, (String)systemId);
            }
            catch (IOException e) {
                return new InputSource(new StringReader(""));
            }
        }

        public String toString() {
            return this.buf.toString();
        }
    }
}

