/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;
import org.junit.Assert;
import org.junit.Test;

public class DSComponentTestCase
extends AbstractDSModelTestCase {
    @Test
    public void testAddDefaultComponent() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        Assert.assertEquals((Object)component.getName(), (Object)"sample");
        Assert.assertEquals((Object)component.getActivateMethod(), null);
        Assert.assertEquals((Object)component.getDeactivateMethod(), null);
        Assert.assertEquals((Object)component.getModifiedMethod(), null);
        Assert.assertTrue((boolean)component.getEnabled());
    }

    @Test
    public void testAddComponentwithAllAttributes() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        Assert.assertEquals((Object)component.getName(), (Object)"sample");
        component.setEnabled(false);
        component.setAttributeName("NewName");
        component.setFactory("NewFactory");
        component.setImmediate(true);
        component.setActivateMethod("start");
        component.setDeactivateMethod("stop");
        component.setModifiedeMethod("modified");
        Assert.assertFalse((boolean)component.getEnabled());
        Assert.assertEquals((Object)component.getAttributeName(), (Object)"NewName");
        Assert.assertEquals((Object)component.getFactory(), (Object)"NewFactory");
        Assert.assertTrue((boolean)component.getImmediate());
        Assert.assertEquals((Object)component.getActivateMethod(), (Object)"start");
        Assert.assertEquals((Object)component.getDeactivateMethod(), (Object)"stop");
        Assert.assertEquals((Object)component.getModifiedMethod(), (Object)"modified");
    }

    @Test
    public void testAddMoveRemoveChildrens() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSImplementation implementation = factory.createImplementation();
        implementation.setClassName("ImplementationClassName");
        component.setImplementation(implementation);
        IDSProperties properties = factory.createProperties();
        properties.setEntry("PropertiesEntry");
        component.addPropertiesElement(properties);
        IDSProperty property = factory.createProperty();
        property.setPropertyElemBody("Body Values");
        property.setPropertyType("java.lang.String");
        component.addPropertyElement(property);
        IDSService service = factory.createService();
        service.setServiceFactory(true);
        component.setService(service);
        IDSReference reference = factory.createReference();
        reference.setReferenceBind("methodBind");
        reference.setReferenceUnbind("methodUnBind");
        reference.setReferenceInterface("ReferenceInterface");
        reference.setReferenceName("ReferenceName");
        component.addReference(reference);
        IDocumentElementNode childAt4 = component.getChildAt(4);
        component.moveChildNode((IDocumentElementNode)reference, -1, true);
        IDocumentElementNode childAt3 = component.getChildAt(3);
        Assert.assertEquals((Object)childAt4, (Object)childAt3);
        Assert.assertTrue((component.getChildCount() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((component.getImplementation() != null ? 1 : 0) != 0);
        Assert.assertTrue((component.getPropertyElements().length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((component.getPropertiesElements().length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((component.getService() != null ? 1 : 0) != 0);
        Assert.assertTrue((component.getReferences().length == 1 ? 1 : 0) != 0);
        component.removeReference(reference);
        Assert.assertTrue((component.getChildCount() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((component.getImplementation() != null ? 1 : 0) != 0);
        Assert.assertTrue((component.getPropertyElements().length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((component.getPropertiesElements().length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((component.getService() != null ? 1 : 0) != 0);
        Assert.assertTrue((component.getReferences().length == 0 ? 1 : 0) != 0);
        component.removeService(service);
        component.removePropertiesElement(properties);
        Assert.assertTrue((component.getChildCount() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((component.getImplementation() != null ? 1 : 0) != 0);
        Assert.assertTrue((component.getPropertyElements().length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((component.getPropertiesElements().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((component.getService() == null ? 1 : 0) != 0);
        Assert.assertTrue((component.getReferences().length == 0 ? 1 : 0) != 0);
        component.removeChildNode((IDocumentElementNode)implementation);
        component.removePropertyElement(property);
        Assert.assertTrue((component.getChildCount() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((component.getImplementation() == null ? 1 : 0) != 0);
        Assert.assertTrue((component.getPropertyElements().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((component.getPropertiesElements().length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((component.getService() == null ? 1 : 0) != 0);
        Assert.assertTrue((component.getReferences().length == 0 ? 1 : 0) != 0);
    }
}

