/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;
import org.junit.Assert;
import org.junit.Test;

public class DSImplementationTestCase
extends AbstractDSModelTestCase {
    @Test
    public void testAddImplementationComponent() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<implementation class=\"");
        buffer.append("org.example.ds.SampleCommandProvider1\">");
        buffer.append("</implementation>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        IDSImplementation implementation = component.getImplementation();
        Assert.assertTrue((implementation != null ? 1 : 0) != 0);
        String className = implementation.getClassName();
        Assert.assertTrue((boolean)className.equals("org.example.ds.SampleCommandProvider1"));
        Assert.assertEquals((Object)implementation.getName(), (Object)className);
    }

    @Test
    public void testDefaultValuesService() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<implementation>");
        buffer.append("\n");
        buffer.append("</implementation>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        IDSImplementation implementation = component.getImplementation();
        Assert.assertNotNull((Object)implementation);
        Assert.assertTrue((implementation.getClassName() == null ? 1 : 0) != 0);
    }

    @Test
    public void testAddImplementationFactory() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSImplementation Implementation = factory.createImplementation();
        String className = "org.example.ds.SampleCommandProvider";
        Implementation.setClassName(className);
        IDSComponent component = this.fModel.getDSComponent();
        component.setImplementation(Implementation);
        String content = component.toString();
        Assert.assertTrue((boolean)content.contains("class=\"" + className + "\""));
        IDSImplementation Implementation0 = component.getImplementation();
        Assert.assertNotNull((Object)Implementation0);
        Assert.assertTrue((boolean)Implementation0.getClassName().equals(className));
    }
}

