/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import java.util.List;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;
import org.junit.Assert;
import org.junit.Test;

public class DSObjectTestCase
extends AbstractDSModelTestCase {
    @Test
    public void testObject() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSImplementation implementation = factory.createImplementation();
        implementation.setClassName("ImplementationClassName");
        component.setImplementation(implementation);
        IDSProperties properties = factory.createProperties();
        properties.setEntry("PropertiesEntry");
        component.addPropertiesElement(properties);
        IDSProperty property = factory.createProperty();
        property.setPropertyElemBody("Body Values");
        property.setPropertyType("java.lang.String");
        component.addPropertyElement(property);
        IDSService service = factory.createService();
        service.setServiceFactory(true);
        component.setService(service);
        IDSReference reference = factory.createReference();
        reference.setReferenceBind("methodBind");
        reference.setReferenceUnbind("methodUnBind");
        reference.setReferenceInterface("ReferenceInterface");
        reference.setReferenceName("ReferenceName");
        component.addReference(reference);
        List children = component.getChildNodesList();
        Assert.assertTrue((children.size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)component.getModel(), (Object)this.fModel);
        IDSObject child = (IDSObject)children.get(0);
        Assert.assertEquals((Object)child.getComponent(), (Object)component);
        Assert.assertEquals((Object)child.getParentNode(), (Object)component);
    }
}

