/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;
import org.junit.Assert;
import org.junit.Test;

public class DSPropertiesTestCase
extends AbstractDSModelTestCase {
    @Test
    public void testAddPropertiesComponent() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<properties entry=\"");
        buffer.append("OSGI-INF/vendor.properties\">");
        buffer.append("</properties>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        IDSProperties[] propertiesElements = component.getPropertiesElements();
        Assert.assertTrue((propertiesElements.length == 1 ? 1 : 0) != 0);
        IDSProperties properties = propertiesElements[0];
        String entry = properties.getEntry();
        Assert.assertTrue((boolean)entry.equals("OSGI-INF/vendor.properties"));
        Assert.assertEquals((Object)entry, (Object)properties.getName());
    }

    @Test
    public void testMultipleProperties() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<properties entry=\"");
        buffer.append("OSGI-INF/vendor.properties1\">");
        buffer.append("</properties>");
        buffer.append("\n");
        buffer.append("<properties entry=\"");
        buffer.append("OSGI-INF/vendor.properties2\">");
        buffer.append("</properties>");
        buffer.append("\n");
        buffer.append("<properties entry=\"");
        buffer.append("OSGI-INF/vendor.properties3\">");
        buffer.append("</properties>");
        buffer.append("\n");
        buffer.append("<properties entry=\"");
        buffer.append("OSGI-INF/vendor.properties4\">");
        buffer.append("</properties>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        IDSProperties[] propertiesElements = component.getPropertiesElements();
        Assert.assertTrue((propertiesElements.length == 4 ? 1 : 0) != 0);
        int i = 0;
        while (i < 4) {
            IDSProperties properties = propertiesElements[i];
            String entry = properties.getEntry();
            Assert.assertTrue((boolean)entry.equals("OSGI-INF/vendor.properties" + (i + 1)));
            ++i;
        }
    }

    @Test
    public void testDefaultValuesService() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<properties>");
        buffer.append("\n");
        buffer.append("</properties>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        IDSProperties[] propertiesElements = component.getPropertiesElements();
        Assert.assertTrue((propertiesElements.length == 1 ? 1 : 0) != 0);
        IDSProperties properties = propertiesElements[0];
        Assert.assertTrue((properties.getEntry() == null ? 1 : 0) != 0);
    }

    @Test
    public void testAddPropertiesFactory() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSProperties Properties = factory.createProperties();
        String entry = "OSGI-INF/vendor.propertiesFactory";
        Properties.setEntry(entry);
        IDSComponent component = this.fModel.getDSComponent();
        component.addPropertiesElement(Properties);
        String content = component.toString();
        Assert.assertTrue((boolean)content.contains("entry=\"" + entry + "\""));
        IDSProperties[] PropertiesElements = component.getPropertiesElements();
        IDSProperties Properties0 = PropertiesElements[0];
        Assert.assertNotNull((Object)Properties0);
        Assert.assertTrue((boolean)Properties0.getEntry().equals(entry));
    }
}

