/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;
import org.junit.Assert;
import org.junit.Test;

public class DSProvideTestCase
extends AbstractDSModelTestCase {
    @Test
    public void testAddCompleteProvidedService() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<service servicefactory=\"true\" >");
        buffer.append("\n");
        buffer.append("<provide interface=\"");
        buffer.append("java.lang.Runnable\">");
        buffer.append("</provide>");
        buffer.append("\n");
        buffer.append("</service>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        IDSService service = this.fModel.getDSComponent().getService();
        Assert.assertNotNull((Object)service);
        IDSProvide[] providedServices = service.getProvidedServices();
        Assert.assertTrue((providedServices.length == 1 ? 1 : 0) != 0);
        IDSProvide provide = providedServices[0];
        Assert.assertTrue((boolean)provide.getInterface().equals("java.lang.Runnable"));
        String interfaceName = "java.lang.String";
        provide.setInterface(interfaceName);
        String content = this.fModel.getDSComponent().toString();
        Assert.assertTrue((boolean)content.contains(interfaceName));
        Assert.assertEquals((Object)provide.getName(), (Object)interfaceName);
    }

    @Test
    public void testAddProvidedServicebyFactory() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSService service = factory.createService();
        service.setServiceFactory(true);
        IDSComponent component = this.fModel.getDSComponent();
        component.setService(service);
        IDSProvide provide = factory.createProvide();
        provide.setInterface("java.lang.Runnable");
        service.addProvidedService(provide);
        String content = component.toString();
        Assert.assertTrue((boolean)content.contains("interface=\"java.lang.Runnable\""));
        IDSService service0 = component.getService();
        Assert.assertNotNull((Object)service0);
        Assert.assertTrue((boolean)service0.getServiceFactory());
        IDSProvide[] providedServices = service.getProvidedServices();
        IDSProvide provide0 = providedServices[0];
        Assert.assertNotNull((Object)provide0);
        Assert.assertTrue((boolean)provide0.getInterface().equals("java.lang.Runnable"));
    }
}

