/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;
import org.junit.Assert;
import org.junit.Test;

public class DSReferenceTestCase
extends AbstractDSModelTestCase {
    @Test
    public void testServiceReference() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        IDSReference reference = this.fModel.getFactory().createReference();
        String name = "HTTP";
        String interfaceName = "org.osgi.service.http.HttpService";
        String cardinality = "0..n";
        String policy = "dynamic";
        String bind = "setPage";
        String unbind = "unsetPage";
        String target = "(component.factory=acme.application)";
        reference.setReferenceName(name);
        reference.setReferenceInterface(interfaceName);
        reference.setReferenceCardinality(cardinality);
        reference.setReferencePolicy(policy);
        reference.setReferenceBind(bind);
        reference.setReferenceUnbind(unbind);
        reference.setReferenceTarget(target);
        component.addReference(reference);
        IDSReference[] references = component.getReferences();
        Assert.assertTrue((references.length == 1 ? 1 : 0) != 0);
        IDSReference reference0 = references[0];
        Assert.assertEquals((Object)reference0.getReferenceName(), (Object)name);
        Assert.assertEquals((Object)reference0.getReferenceInterface(), (Object)interfaceName);
        Assert.assertEquals((Object)reference0.getReferenceCardinality(), (Object)cardinality);
        Assert.assertEquals((Object)reference0.getReferencePolicy(), (Object)policy);
        Assert.assertEquals((Object)reference0.getReferenceBind(), (Object)bind);
        Assert.assertEquals((Object)reference0.getReferenceUnbind(), (Object)unbind);
        Assert.assertEquals((Object)reference0.getName(), (Object)name);
    }

    @Test
    public void testDefaultServiceReference() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertNotNull((Object)component);
        IDSReference reference = this.fModel.getFactory().createReference();
        component.addReference(reference);
        IDSReference[] references = component.getReferences();
        Assert.assertTrue((references.length == 1 ? 1 : 0) != 0);
        IDSReference reference0 = references[0];
        String defautCardinality = "1..1";
        String defaultPolicy = "static";
        Assert.assertEquals((Object)reference0.getReferenceCardinality(), (Object)defautCardinality);
        Assert.assertEquals((Object)reference0.getReferencePolicy(), (Object)defaultPolicy);
    }
}

