/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.tests;

import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.tests.AbstractDSModelTestCase;
import org.junit.Assert;
import org.junit.Test;

public class DSServiceTestCase
extends AbstractDSModelTestCase {
    @Test
    public void testAddCompleteService() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<service servicefactory=\"true\" >");
        buffer.append("\n");
        buffer.append("<provide interface=\"");
        buffer.append("java.lang.Runnable\">");
        buffer.append("</provide>");
        buffer.append("\n");
        buffer.append("</service>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertTrue((component.getChildCount() == 1 ? 1 : 0) != 0);
        IDocumentElementNode child = component.getChildAt(0);
        Assert.assertTrue((boolean)(child instanceof IDSService));
        IDSService service = (IDSService)child;
        Assert.assertTrue((boolean)service.getServiceFactory());
        Assert.assertTrue((child.getChildCount() == 1 ? 1 : 0) != 0);
        IDSProvide[] providedServices = service.getProvidedServices();
        IDSProvide provide = providedServices[0];
        String interface1 = provide.getInterface();
        Assert.assertTrue((boolean)interface1.equals("java.lang.Runnable"));
        service.setServiceFactory(false);
        String string = this.fModel.getDSComponent().toString();
        Assert.assertTrue((boolean)string.contains("servicefactory=\"false\""));
        Assert.assertTrue((!service.getServiceFactory() ? 1 : 0) != 0);
        Assert.assertEquals((Object)service.getName(), (Object)"service");
    }

    @Test
    public void testMultipleProvideService() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<service>");
        buffer.append("\n");
        buffer.append("<provide interface=\"");
        buffer.append("java.lang.Runnable1\"/>");
        buffer.append("\n");
        buffer.append("<provide interface=\"");
        buffer.append("java.lang.Runnable2\"/>");
        buffer.append("\n");
        buffer.append("<provide interface=\"");
        buffer.append("java.lang.Runnable3\"/>");
        buffer.append("\n");
        buffer.append("<provide interface=\"");
        buffer.append("java.lang.Runnable4\"/>");
        buffer.append("\n");
        buffer.append("<provide interface=\"");
        buffer.append("java.lang.Runnable5\"/>");
        buffer.append("\n");
        buffer.append("<provide interface=\"");
        buffer.append("java.lang.Runnable6\"/> ");
        buffer.append("</service>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertTrue((component.getChildCount() == 1 ? 1 : 0) != 0);
        IDocumentElementNode child = component.getChildAt(0);
        Assert.assertTrue((boolean)(child instanceof IDSService));
        Assert.assertTrue((child.getChildCount() == 6 ? 1 : 0) != 0);
        int i = 0;
        while (i < 6) {
            IDocumentElementNode grandChild = child.getChildAt(i);
            IDSProvide provide = (IDSProvide)grandChild;
            String interface1 = provide.getInterface();
            Assert.assertTrue((boolean)interface1.equals("java.lang.Runnable" + (i + 1)));
            ++i;
        }
    }

    @Test
    public void testDefaultValuesService() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<service>");
        buffer.append("\n");
        buffer.append("</service>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        Assert.assertTrue((component.getChildCount() == 1 ? 1 : 0) != 0);
        IDocumentElementNode child = component.getChildAt(0);
        Assert.assertTrue((boolean)(child instanceof IDSService));
        IDSService service = (IDSService)child;
        Assert.assertTrue((!service.getServiceFactory() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveChildService() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<service servicefactory=\"true\" >");
        buffer.append("\n");
        buffer.append("<provide interface=\"");
        buffer.append("java.lang.Runnable\">");
        buffer.append("</provide>");
        buffer.append("\n");
        buffer.append("</service>");
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSComponent component = this.fModel.getDSComponent();
        IDSService service = component.getService();
        Assert.assertNotNull((Object)service);
        IDSProvide[] providedServices = service.getProvidedServices();
        Assert.assertTrue((providedServices.length == 1 ? 1 : 0) != 0);
        service.removeProvidedService(providedServices[0]);
        service = component.getService();
        Assert.assertNotNull((Object)service);
        Assert.assertTrue((service.getProvidedServices().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAddServiceFactory() {
        StringBuilder buffer = new StringBuilder();
        this.setXMLContents(buffer, "\n");
        this.load();
        IDSDocumentFactory factory = this.fModel.getFactory();
        IDSService service = factory.createService();
        service.setServiceFactory(true);
        IDSComponent component = this.fModel.getDSComponent();
        component.setService(service);
        String content = component.toString();
        Assert.assertTrue((boolean)content.contains("servicefactory=\"true\""));
        IDSService service0 = component.getService();
        Assert.assertNotNull((Object)service0);
        Assert.assertTrue((boolean)service0.getServiceFactory());
    }
}

