/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.notify.Notifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug320857Test {
    private IEclipseContext applicationContext;
    private IPresentationEngine engine;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        this.ems = (EModelService)this.applicationContext.get(EModelService.class);
    }

    protected String getEngineURI() {
        return "bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.HeadlessContextPresentationEngine";
    }

    @After
    public void tearDown() throws Exception {
        this.applicationContext.dispose();
    }

    private void initialize(IEclipseContext applicationContext, MApplication application) {
        applicationContext.set(MApplication.class, (Object)application);
        application.setContext(applicationContext);
        UIEventPublisher ep = new UIEventPublisher(applicationContext);
        ((Notifier)application).eAdapters().add((Object)ep);
        applicationContext.set(UIEventPublisher.class, (Object)ep);
    }

    private IPresentationEngine getEngine() {
        if (this.engine == null) {
            IContributionFactory contributionFactory = (IContributionFactory)this.applicationContext.get(IContributionFactory.class);
            Object newEngine = contributionFactory.create(this.getEngineURI(), this.applicationContext);
            Assert.assertTrue((boolean)(newEngine instanceof IPresentationEngine));
            this.applicationContext.set(IPresentationEngine.class.getName(), newEngine);
            this.engine = (IPresentationEngine)newEngine;
        }
        return this.engine;
    }

    @Test
    public void testBug320857() throws Exception {
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.initialize(this.applicationContext, application);
        this.getEngine().createGui((MUIElement)window);
        this.applicationContext.set(Bug320857.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return ContextInjectionFactory.make(Bug320857.class, (IEclipseContext)context);
            }
        });
        IEclipseContext partContext = part.getContext();
        Bug320857 selectionServiceA = (Bug320857)partContext.get(Bug320857.class);
        selectionServiceA.setSelection(new Object());
        Bug320857 selectionServiceB = (Bug320857)partContext.get(Bug320857.class);
        Assert.assertEquals((Object)selectionServiceA, (Object)selectionServiceB);
        Assert.assertSame((Object)selectionServiceA, (Object)selectionServiceB);
    }

    public static class Bug320857 {
        static final String OUT_SELECTION = "output.selection";
        @Inject
        private IEclipseContext context;

        @Inject
        void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
            if (part != null) {
                IEclipseContext partContext = part.getContext();
                partContext.containsKey(OUT_SELECTION);
            }
        }

        public void setSelection(Object selection) {
            this.context.set(OUT_SELECTION, selection);
        }
    }
}

