/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.emf.ecore.EObject;
import org.junit.Assert;
import org.junit.Test;

public class E4ResourceTest {
    @Test
    public void bug_leak_517124() {
        E4XMIResource r = new E4XMIResource();
        MApplication a = MApplicationFactory.INSTANCE.createApplication();
        MTrimmedWindow w = MBasicFactory.INSTANCE.createTrimmedWindow();
        a.getChildren().add(w);
        r.getContents().add((Object)((EObject)a));
        String aId = r.getID((EObject)a);
        String wId = r.getID((EObject)w);
        Assert.assertNotNull((Object)aId);
        Assert.assertNotNull((Object)wId);
        this.assertThatMapsAreEquals(r.getIDToEObjectMap(), r.getEObjectToIDMap());
        a.getChildren().remove(w);
        this.assertThatMapsAreEquals(r.getIDToEObjectMap(), r.getEObjectToIDMap());
        a.getChildren().add(w);
        this.assertThatMapsAreEquals(r.getIDToEObjectMap(), r.getEObjectToIDMap());
        a.getChildren().remove(w);
        this.assertThatMapsAreEquals(r.getIDToEObjectMap(), r.getEObjectToIDMap());
    }

    private void assertThatMapsAreEquals(Map<String, EObject> idToObject, Map<EObject, String> objectToId) {
        Assert.assertEquals((long)idToObject.size(), (long)objectToId.size());
        Map<String, EObject> checkMap = objectToId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        for (Map.Entry<String, EObject> e : idToObject.entrySet()) {
            EObject eObject = checkMap.get(e.getKey());
            Assert.assertSame((Object)e.getValue(), (Object)eObject);
        }
    }
}

