/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EModelServiceFindTest {
    private IEclipseContext applicationContext;
    MApplication app = null;

    @Before
    public void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
    }

    @After
    public void tearDown() throws Exception {
        this.applicationContext.dispose();
    }

    private MApplication createApplication() {
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        MApplication app = (MApplication)modelService.createModelElement(MApplication.class);
        app.setContext(this.applicationContext);
        MWindow window = (MWindow)modelService.createModelElement(MWindow.class);
        window.setElementId("singleValidId");
        app.getChildren().add(window);
        MMenu mainMenu = (MMenu)modelService.createModelElement(MMenu.class);
        window.setMainMenu(mainMenu);
        MMenu mainMenuItem = (MMenu)modelService.createModelElement(MMenu.class);
        mainMenu.getChildren().add(mainMenuItem);
        MPartSashContainer psc = (MPartSashContainer)modelService.createModelElement(MPartSashContainer.class);
        psc.setElementId("twoValidIds");
        psc.getTags().add("oneValidTag");
        window.getChildren().add(psc);
        MPartStack stack = (MPartStack)modelService.createModelElement(MPartStack.class);
        stack.getTags().add("twoValidTags");
        psc.getChildren().add(stack);
        MPart part1 = (MPart)modelService.createModelElement(MPart.class);
        part1.setElementId("twoValidIds");
        stack.getChildren().add(part1);
        MPart part2 = (MPart)modelService.createModelElement(MPart.class);
        part2.getTags().add("twoValidTags");
        part2.getTags().add("secondTag");
        stack.getChildren().add(part2);
        MPart part3 = (MPart)modelService.createModelElement(MPart.class);
        psc.getChildren().add(part3);
        MMenu menu = (MMenu)modelService.createModelElement(MMenu.class);
        menu.setElementId("menuId");
        part1.getMenus().add(menu);
        MMenu menuItem1 = (MMenu)modelService.createModelElement(MMenu.class);
        menuItem1.setElementId("menuItem1Id");
        menu.getChildren().add(menuItem1);
        MMenu menuItem2 = (MMenu)modelService.createModelElement(MMenu.class);
        menuItem2.setElementId("menuItem2Id");
        menu.getChildren().add(menuItem2);
        MToolBar toolBar = (MToolBar)modelService.createModelElement(MToolBar.class);
        toolBar.setElementId("toolBarId");
        part2.setToolbar(toolBar);
        MToolControl toolControl1 = (MToolControl)modelService.createModelElement(MToolControl.class);
        toolControl1.setElementId("toolControl1Id");
        toolBar.getChildren().add(toolControl1);
        MToolControl toolControl2 = (MToolControl)modelService.createModelElement(MToolControl.class);
        toolControl2.setElementId("toolControl2Id");
        toolBar.getChildren().add(toolControl2);
        return app;
    }

    @Test
    public void testFindElementsIdOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        List elements1 = modelService.findElements((MUIElement)application, "singleValidId", null);
        Assert.assertEquals((long)elements1.size(), (long)1L);
        List elements2 = modelService.findElements((MUIElement)application, "twoValidIds", null);
        Assert.assertEquals((long)elements2.size(), (long)2L);
        List elements3 = modelService.findElements((MUIElement)application, "invalidId", null);
        Assert.assertEquals((long)elements3.size(), (long)0L);
        List elements4 = modelService.findElements((MUIElement)application, "menuItem1Id", null, null, 125);
        Assert.assertEquals((long)1L, (long)elements4.size());
        List elements5 = modelService.findElements((MUIElement)application, "toolControl1Id", null, null, 125);
        Assert.assertEquals((long)1L, (long)elements5.size());
    }

    @Test
    public void testFindElementsTypeOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        List parts = modelService.findElements((MUIElement)application, null, MPart.class);
        Assert.assertEquals((long)parts.size(), (long)3L);
        List stacks = modelService.findElements((MUIElement)application, null, MPartStack.class);
        Assert.assertEquals((long)stacks.size(), (long)1L);
        List dirtyableElements = modelService.findElements((MUIElement)application, null, MDirtyable.class);
        Assert.assertEquals((long)dirtyableElements.size(), (long)3L);
        List menuElements = modelService.findElements((MUIElement)application, null, MMenuElement.class, null, 125);
        Assert.assertEquals((long)5L, (long)menuElements.size());
        List toolBarElements = modelService.findElements((MUIElement)application, null, MToolBarElement.class, null, 125);
        Assert.assertEquals((long)2L, (long)toolBarElements.size());
        List uiElements = modelService.findElements((MUIElement)application, null, null, null, 125);
        Assert.assertEquals((long)15L, (long)uiElements.size());
        List strings = modelService.findElements((MUIElement)application, null, String.class);
        Assert.assertEquals((long)strings.size(), (long)0L);
    }

    @Test
    public void testFindElementsTagsOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("oneValidTag");
        List oneTags = modelService.findElements((MUIElement)application, null, null, tags);
        Assert.assertEquals((long)oneTags.size(), (long)1L);
        tags.clear();
        tags.add("twoValidTags");
        List twoTags = modelService.findElements((MUIElement)application, null, null, tags);
        Assert.assertEquals((long)twoTags.size(), (long)2L);
        tags.clear();
        tags.add("invalidTag");
        List invalidTags = modelService.findElements((MUIElement)application, null, null, tags);
        Assert.assertEquals((long)invalidTags.size(), (long)0L);
        tags.clear();
        tags.add("twoValidTags");
        tags.add("secondTag");
        List combinedTags = modelService.findElements((MUIElement)application, null, null, tags);
        Assert.assertEquals((long)combinedTags.size(), (long)1L);
        tags.clear();
        tags.add("oneValidTag");
        tags.add("secondTag");
        List unmatchedTags = modelService.findElements((MUIElement)application, null, null, tags);
        Assert.assertEquals((long)unmatchedTags.size(), (long)0L);
    }

    @Test
    public void testFindElementsCombinations() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("oneValidTag");
        List idAndType = modelService.findElements((MUIElement)application, "twoValidIds", MPartSashContainer.class, tags);
        Assert.assertEquals((long)idAndType.size(), (long)1L);
        List typeAndTag = modelService.findElements((MUIElement)application, null, MPartSashContainer.class, tags);
        Assert.assertEquals((long)typeAndTag.size(), (long)1L);
        List idAndTag = modelService.findElements((MUIElement)application, "twoValidIds", null, tags);
        Assert.assertEquals((long)idAndTag.size(), (long)1L);
        List idAndTypeAndTags = modelService.findElements((MUIElement)application, "twoValidIds", MPartSashContainer.class);
        Assert.assertEquals((long)idAndTypeAndTags.size(), (long)1L);
        List badIdAndTypeAndTags = modelService.findElements((MUIElement)application, "invalidId", MPartSashContainer.class);
        Assert.assertEquals((long)badIdAndTypeAndTags.size(), (long)0L);
    }

    @Test
    public void testFindElements_NullCheck() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        try {
            modelService.find("a", null);
            Assert.fail((String)"An exception should have prevented a null parameter to find(*)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            modelService.findElements(null, null, null);
            Assert.fail((String)"An exception should have prevented a null parameter to findElements(*)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            modelService.findElements(null, null, null, null, 29);
            Assert.fail((String)"An exception should have prevented a null parameter to findElements(*)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFlags() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        List toolBarElements = modelService.findElements((MUIElement)application, null, MToolBarElement.class, null, 4);
        Assert.assertEquals((long)0L, (long)toolBarElements.size());
        toolBarElements = modelService.findElements((MUIElement)application, null, MToolBarElement.class, null, 68);
        Assert.assertEquals((long)2L, (long)toolBarElements.size());
        List menuElements = modelService.findElements((MUIElement)application, null, MMenuElement.class, null, 4);
        Assert.assertEquals((long)0L, (long)menuElements.size());
        menuElements = modelService.findElements((MUIElement)application, null, MMenuElement.class, null, 68);
        Assert.assertEquals((long)3L, (long)menuElements.size());
        menuElements = modelService.findElements((MUIElement)application, null, MMenuElement.class, null, 36);
        Assert.assertEquals((long)2L, (long)menuElements.size());
    }

    private MHandler findHandler(EModelService ms, MApplicationElement searchRoot, String id) {
        if (searchRoot == null || id == null) {
            return null;
        }
        List handlers = ms.findElements(searchRoot, MHandler.class, 29, element -> element instanceof MHandler && id.equals(element.getElementId()));
        if (handlers.size() > 0) {
            return (MHandler)handlers.get(0);
        }
        return null;
    }

    @Test
    public void testFindHandler() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        MHandler handler1 = (MHandler)modelService.createModelElement(MHandler.class);
        handler1.setElementId("handler1");
        application.getHandlers().add(handler1);
        MHandler handler2 = (MHandler)modelService.createModelElement(MHandler.class);
        handler2.setElementId("handler2");
        application.getHandlers().add(handler2);
        MHandler foundHandler = null;
        foundHandler = this.findHandler(modelService, (MApplicationElement)application, "handler1");
        Assert.assertNotNull((Object)foundHandler);
        Assert.assertSame((Object)handler1, (Object)foundHandler);
        foundHandler = this.findHandler(modelService, (MApplicationElement)application, "invalidId");
        Assert.assertNull((Object)foundHandler);
        foundHandler = this.findHandler(modelService, null, "handler1");
        Assert.assertNull((Object)foundHandler);
        foundHandler = this.findHandler(modelService, (MApplicationElement)application, "");
        Assert.assertNull((Object)foundHandler);
        foundHandler = this.findHandler(modelService, (MApplicationElement)application, null);
        Assert.assertNull((Object)foundHandler);
    }

    @Test
    public void testFindMKeyBindings() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        MBindingTable bindingTable = (MBindingTable)modelService.createModelElement(MBindingTable.class);
        MKeyBinding keyBinding = (MKeyBinding)modelService.createModelElement(MKeyBinding.class);
        bindingTable.getBindings().add(keyBinding);
        application.getBindingTables().add(bindingTable);
        List elements = modelService.findElements((MApplicationElement)application, MKeyBinding.class, 29, element -> element instanceof MKeyBinding);
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)keyBinding, elements.get(0));
    }

    @Test
    public void testFindAddons() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        MAddon addon = MApplicationFactory.INSTANCE.createAddon();
        application.getAddons().add(addon);
        List elements = modelService.findElements((MApplicationElement)application, MAddon.class, 29, element -> element instanceof MAddon);
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)addon, elements.get(0));
    }

    @Test
    public void testBug314685() {
        MApplication application = this.createApplication();
        application.setContext(this.applicationContext);
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
        Assert.assertNotNull((Object)modelService);
        MWindow window = (MWindow)modelService.createModelElement(MWindow.class);
        application.getChildren().add(window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)modelService.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective perspectiveA = (MPerspective)modelService.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        MPerspective perspectiveB = (MPerspective)modelService.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStack = (MPartStack)modelService.createModelElement(MPartStack.class);
        window.getSharedElements().add(partStack);
        MPart part = (MPart)modelService.createModelElement(MPart.class);
        partStack.getChildren().add(part);
        MPlaceholder placeholderA = (MPlaceholder)modelService.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partStack);
        perspectiveA.getChildren().add(placeholderA);
        MPlaceholder placeholderB = (MPlaceholder)modelService.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(placeholderB);
        List elements = modelService.findElements((MUIElement)window, null, MPart.class);
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)part, elements.get(0));
    }
}

