/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.tests.application.UITest;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.e4.ui.workbench.swt.DisplayUISynchronize;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Test;

public class ESelectionServiceTest
extends UITest {
    @Test
    public void testGetSelection() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        window.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextA = partA.getContext();
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceA = (ESelectionService)contextA.get(ESelectionService.class);
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class);
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class);
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        Object selection1 = new Object();
        Object selection2 = new Object();
        serviceA.setSelection(selection1);
        Assert.assertEquals((Object)selection1, (Object)windowService.getSelection());
        Assert.assertEquals((Object)selection1, (Object)serviceA.getSelection());
        Assert.assertEquals((Object)selection1, (Object)serviceB.getSelection());
        serviceB.setSelection(selection2);
        Assert.assertEquals((Object)selection1, (Object)windowService.getSelection());
        Assert.assertEquals((Object)selection1, (Object)serviceA.getSelection());
        Assert.assertEquals((Object)selection1, (Object)serviceB.getSelection());
        partService.activate(partB);
        Assert.assertEquals((Object)selection2, (Object)windowService.getSelection());
        Assert.assertEquals((Object)selection2, (Object)serviceA.getSelection());
        Assert.assertEquals((Object)selection2, (Object)serviceB.getSelection());
    }

    @Test
    public void testGetSelection_Id() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        window.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextA = partA.getContext();
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceA = (ESelectionService)contextA.get(ESelectionService.class);
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class);
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class);
        Object selection1 = new Object();
        Object selection2 = new Object();
        serviceA.setSelection(selection1);
        Assert.assertEquals((Object)selection1, (Object)windowService.getSelection("partA"));
        Assert.assertEquals((Object)selection1, (Object)serviceA.getSelection("partA"));
        Assert.assertEquals((Object)selection1, (Object)serviceB.getSelection("partA"));
        Assert.assertNull((Object)windowService.getSelection("partB"));
        Assert.assertNull((Object)serviceA.getSelection("partB"));
        Assert.assertNull((Object)serviceB.getSelection("partB"));
        serviceB.setSelection(selection2);
        Assert.assertEquals((Object)selection1, (Object)windowService.getSelection("partA"));
        Assert.assertEquals((Object)selection1, (Object)serviceA.getSelection("partA"));
        Assert.assertEquals((Object)selection1, (Object)serviceB.getSelection("partA"));
        Assert.assertEquals((Object)selection2, (Object)windowService.getSelection("partB"));
        Assert.assertEquals((Object)selection2, (Object)serviceA.getSelection("partB"));
        Assert.assertEquals((Object)selection2, (Object)serviceB.getSelection("partB"));
    }

    @Test
    public void testSelectionListener() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        window.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class);
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class);
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        Object selection = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener((ISelectionListener)listener);
        serviceB.setSelection(selection);
        listener.reset();
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)listener.getPart());
        Assert.assertEquals((Object)selection, (Object)listener.getSelection());
        windowService.removeSelectionListener((ISelectionListener)listener);
        listener.reset();
        partService.activate(partA);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
    }

    @Test
    public void testSelectionListener2() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        window.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextA = partA.getContext();
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceA = (ESelectionService)contextA.get(ESelectionService.class);
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class);
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class);
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        Object selectionA = new Object();
        Object selectionB = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener((ISelectionListener)listener);
        serviceA.setSelection(selectionA);
        Assert.assertEquals((Object)partA, (Object)listener.getPart());
        Assert.assertEquals((Object)selectionA, (Object)listener.getSelection());
        listener.reset();
        serviceA.setSelection(selectionA);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        serviceB.setSelection(selectionB);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)listener.getPart());
        Assert.assertEquals((Object)selectionB, (Object)listener.getSelection());
        windowService.removeSelectionListener((ISelectionListener)listener);
        listener.reset();
        partService.activate(partA);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
    }

    @Test
    public void testSelectionListener3() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        window.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextA = partA.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceA = (ESelectionService)contextA.get(ESelectionService.class);
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class);
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        Object selectionA = new Object();
        Object selectionB = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener((ISelectionListener)listener);
        serviceA.setSelection(selectionA);
        Assert.assertEquals((Object)partA, (Object)listener.getPart());
        Assert.assertEquals((Object)selectionA, (Object)listener.getSelection());
        listener.reset();
        serviceA.setSelection(selectionA);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        serviceA.setSelection(selectionB);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
    }

    @Test
    public void testBug314538() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext windowContext = window.getContext();
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class);
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener((ISelectionListener)listener);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        perspective.getChildren().add(partB);
        IEclipseContext contextB = partB.getContext();
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class);
        Object selection = new Object();
        serviceB.setSelection(selection);
        listener.reset();
        partService.activate(partB);
        Assert.assertEquals((Object)partB, (Object)listener.getPart());
        Assert.assertEquals((Object)selection, (Object)listener.getSelection());
        windowService.removeSelectionListener((ISelectionListener)listener);
        listener.reset();
        partService.activate(partA);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
    }

    @Test
    public void testSelectionListener_Id() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        window.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextA = partA.getContext();
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceA = (ESelectionService)contextA.get(ESelectionService.class);
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class);
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class);
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        Object selectionA = new Object();
        Object selectionB = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener("partB", (ISelectionListener)listener);
        serviceA.setSelection(selectionA);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        partService.activate(partB);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        serviceB.setSelection(selectionB);
        Assert.assertEquals((Object)partB, (Object)listener.getPart());
        Assert.assertEquals((Object)selectionB, (Object)listener.getSelection());
        listener.reset();
        serviceA.setSelection(selectionB);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        windowService.removeSelectionListener("partB", (ISelectionListener)listener);
        serviceB.setSelection(selectionA);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
    }

    @Test
    public void testSelectionListener_Id2() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        window.getChildren().add(partB);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext contextB = partB.getContext();
        IEclipseContext windowContext = window.getContext();
        ESelectionService serviceB = (ESelectionService)contextB.get(ESelectionService.class);
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class);
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        Object selectionB = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener("partB", (ISelectionListener)listener);
        partService.activate(partA);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        listener.reset();
        serviceB.setSelection(selectionB);
        Assert.assertEquals((Object)partB, (Object)listener.getPart());
        Assert.assertEquals((Object)selectionB, (Object)listener.getSelection());
    }

    @Test
    public void testSelectionListener_Id3() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        window.getChildren().add(partA);
        window.setSelectedElement((MUIElement)partA);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partC.setElementId("partC");
        partStack.getChildren().add(partC);
        partStack.setSelectedElement((MUIElement)partB);
        window.getChildren().add(partStack);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext windowContext = window.getContext();
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class);
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        Object selection = new Object();
        SelectionListener listener = new SelectionListener();
        windowService.addSelectionListener("partC", (ISelectionListener)listener);
        partService.showPart("partC", EPartService.PartState.CREATE);
        Assert.assertNull((Object)listener.getPart());
        Assert.assertNull((Object)listener.getSelection());
        IEclipseContext contextC = partC.getContext();
        ESelectionService serviceC = (ESelectionService)contextC.get(ESelectionService.class);
        listener.reset();
        serviceC.setSelection(selection);
        Assert.assertEquals((Object)partC, (Object)listener.getPart());
        Assert.assertEquals((Object)selection, (Object)listener.getSelection());
    }

    @Test
    public void testOnePartSelection() throws Exception {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        ProviderPart p = new ProviderPart();
        ContextInjectionFactory.inject((Object)p, (IEclipseContext)part.getContext());
        Assert.assertNull((Object)p.input);
        Object selection = new Object();
        p.setSelection(selection);
        Assert.assertEquals((Object)selection, (Object)p.input);
        p.setSelection(null);
        Assert.assertNull((Object)p.input);
    }

    @Test
    public void testTwoPartHandlerExecute() throws Exception {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partB);
        window.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext windowContext = window.getContext();
        IEclipseContext partContextA = partA.getContext();
        IEclipseContext partContextB = partB.getContext();
        ProviderPart partOneImpl = new ProviderPart();
        ContextInjectionFactory.inject((Object)partOneImpl, (IEclipseContext)partContextA);
        ConsumerPart partTwoImpl = new ConsumerPart();
        ContextInjectionFactory.inject((Object)partTwoImpl, (IEclipseContext)partContextB);
        Object selection = new Object();
        partOneImpl.setSelection(selection);
        UseSelectionHandler handler = new UseSelectionHandler();
        Assert.assertNull((Object)handler.selection);
        ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)this.applicationContext, null);
        Assert.assertEquals((Object)selection, (Object)handler.selection);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)windowContext, null);
        Assert.assertEquals((Object)selection, (Object)handler.selection);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)partContextA, null);
        Assert.assertEquals((Object)selection, (Object)handler.selection);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)partContextB, null);
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        partService.activate(partB);
        ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)this.applicationContext, null);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)windowContext, null);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)partContextA, null);
        handler.selection = null;
        ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)partContextB, null);
    }

    @Test
    public void testThreePartSelection() throws Exception {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partC);
        window.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext windowContext = window.getContext();
        IEclipseContext partContextA = partA.getContext();
        IEclipseContext partContextB = partB.getContext();
        IEclipseContext partContextC = partC.getContext();
        ProviderPart partOneImpl = new ProviderPart();
        ContextInjectionFactory.inject((Object)partOneImpl, (IEclipseContext)partContextA);
        ConsumerPart partTwoImpl = new ConsumerPart();
        ContextInjectionFactory.inject((Object)partTwoImpl, (IEclipseContext)partContextB);
        ProviderPart partThreeImpl = new ProviderPart();
        ContextInjectionFactory.inject((Object)partThreeImpl, (IEclipseContext)partContextC);
        ESelectionService windowService = (ESelectionService)windowContext.get(ESelectionService.class);
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        Object selection = new Object();
        Object selection2 = new Object();
        Assert.assertNull((Object)windowService.getSelection());
        Assert.assertNull((Object)partOneImpl.input);
        Assert.assertNull((Object)partTwoImpl.input);
        Assert.assertNull((Object)partThreeImpl.input);
        partOneImpl.setSelection(selection);
        Assert.assertEquals((Object)selection, (Object)windowService.getSelection());
        Assert.assertEquals((Object)selection, (Object)partOneImpl.input);
        partThreeImpl.setSelection(selection2);
        Assert.assertEquals((Object)selection, (Object)windowService.getSelection());
        Assert.assertEquals((Object)selection, (Object)partOneImpl.input);
        partService.activate(partB);
        partService.activate(partC);
        Assert.assertEquals((Object)selection2, (Object)windowService.getSelection());
        Assert.assertEquals((Object)selection2, (Object)partThreeImpl.input);
    }

    @Test
    public void testPartOneTracksPartThree() throws Exception {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partC.setElementId("partC");
        window.getChildren().add(partC);
        window.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        final IEclipseContext partContextA = partA.getContext();
        IEclipseContext partContextB = partB.getContext();
        IEclipseContext partContextC = partC.getContext();
        final TrackingProviderPart partOneImpl = new TrackingProviderPart();
        ContextInjectionFactory.inject((Object)partOneImpl, (IEclipseContext)partContextA);
        ConsumerPart partTwoImpl = new ConsumerPart();
        ContextInjectionFactory.inject((Object)partTwoImpl, (IEclipseContext)partContextB);
        ProviderPart partThreeImpl = new ProviderPart();
        ContextInjectionFactory.inject((Object)partThreeImpl, (IEclipseContext)partContextC);
        Object selection = new Object();
        Object selection2 = new Object();
        partOneImpl.setSelection(selection);
        partThreeImpl.setSelection(selection2);
        Assert.assertEquals((Object)selection, (Object)partOneImpl.input);
        Assert.assertNull((Object)partOneImpl.otherSelection);
        partContextC.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                ESelectionService s = (ESelectionService)partContextA.get(ESelectionService.class);
                partOneImpl.setOtherSelection(s.getSelection("partC"));
                return true;
            }
        });
        Assert.assertEquals((Object)selection, (Object)partOneImpl.input);
        Assert.assertEquals((Object)selection2, (Object)partOneImpl.otherSelection);
        partThreeImpl.setSelection(selection);
        Assert.assertEquals((Object)selection, (Object)partOneImpl.input);
        Assert.assertEquals((Object)selection, (Object)partOneImpl.otherSelection);
        partThreeImpl.setSelection(null);
        Assert.assertEquals((Object)selection, (Object)partOneImpl.input);
        Assert.assertNull((Object)partOneImpl.otherSelection);
    }

    @Test
    public void testPartOneTracksPartThree2() throws Exception {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partC.setElementId("partC");
        window.getChildren().add(partC);
        window.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext partContextA = partA.getContext();
        IEclipseContext partContextB = partB.getContext();
        IEclipseContext partContextC = partC.getContext();
        TrackingProviderPart partOneImpl = new TrackingProviderPart();
        ContextInjectionFactory.inject((Object)partOneImpl, (IEclipseContext)partContextA);
        ConsumerPart partTwoImpl = new ConsumerPart();
        ContextInjectionFactory.inject((Object)partTwoImpl, (IEclipseContext)partContextB);
        ProviderPart partThreeImpl = new ProviderPart();
        ContextInjectionFactory.inject((Object)partThreeImpl, (IEclipseContext)partContextC);
        Object selection = new Object();
        Object selection2 = new Object();
        Object selection3 = new Object();
        partOneImpl.setSelection(selection);
        partThreeImpl.setSelection(selection2);
        Assert.assertEquals((Object)selection, (Object)partOneImpl.input);
        Assert.assertNull((Object)partOneImpl.otherSelection);
        ESelectionService selectionService = (ESelectionService)partContextA.get(ESelectionService.class);
        selectionService.addSelectionListener(partC.getElementId(), (part, selection1) -> partOneImpl.setOtherSelection(selection1));
        partThreeImpl.setSelection(selection3);
        Assert.assertEquals((Object)selection, (Object)partOneImpl.input);
        Assert.assertEquals((Object)selection3, (Object)partOneImpl.otherSelection);
        partThreeImpl.setSelection(selection);
        Assert.assertEquals((Object)selection, (Object)partOneImpl.input);
        Assert.assertEquals((Object)selection, (Object)partOneImpl.otherSelection);
        partThreeImpl.setSelection(null);
        Assert.assertEquals((Object)selection, (Object)partOneImpl.input);
        Assert.assertNull((Object)partOneImpl.otherSelection);
    }

    @Test
    public void testInjection() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partB);
        window.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext windowContext = window.getContext();
        IEclipseContext partContextA = partA.getContext();
        IEclipseContext partContextB = partB.getContext();
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        partService.activate(partA);
        ESelectionService selectionServiceA = (ESelectionService)partContextA.get(ESelectionService.class);
        ESelectionService selectionServiceB = (ESelectionService)partContextB.get(ESelectionService.class);
        InjectPart injectPart = (InjectPart)ContextInjectionFactory.make(InjectPart.class, (IEclipseContext)partContextA);
        Assert.assertNull((Object)injectPart.selection);
        Target o = new Target("");
        selectionServiceA.setSelection((Object)o);
        Assert.assertEquals((Object)o, (Object)injectPart.selection);
        partService.activate(partB);
        Assert.assertEquals((String)"Part B doesn't post a selection, no change", (Object)o, (Object)injectPart.selection);
        partService.activate(partA);
        Assert.assertEquals((Object)o, (Object)injectPart.selection);
        Target o2 = new Target("");
        selectionServiceB.setSelection((Object)o2);
        Assert.assertEquals((Object)o, (Object)injectPart.selection);
        partService.activate(partB);
        Assert.assertEquals((Object)o2, (Object)injectPart.selection);
        partService.activate(partA);
        Assert.assertEquals((Object)o, (Object)injectPart.selection);
    }

    @Test
    public void testBug343003() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        perspective.getChildren().add(partA);
        perspective.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        ((EPartService)window.getContext().get(EPartService.class)).activate(partA);
        ESelectionService selectionServiceA = (ESelectionService)partA.getContext().get(ESelectionService.class);
        SelectionListener listener = new SelectionListener();
        selectionServiceA.addSelectionListener("partB", (ISelectionListener)listener);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        window.getSharedElements().add(partB);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)partB);
        partB.setCurSharedRef(placeholder);
        perspective.getChildren().add(placeholder);
        Object o = new Object();
        ESelectionService selectionServiceB = (ESelectionService)partB.getContext().get(ESelectionService.class);
        selectionServiceB.setSelection(o);
        Assert.assertEquals((Object)partB, (Object)listener.getPart());
        Assert.assertEquals((Object)o, (Object)listener.getSelection());
    }

    @Test
    public void testBug343984() throws Exception {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.initialize();
        this.applicationContext.set(UISynchronize.class, (Object)new DisplayUISynchronize(Display.getDefault()));
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext context = part.getContext();
        Bug343984Listener listener = new Bug343984Listener();
        listener.context = context;
        ESelectionService selectionService = (ESelectionService)context.get(ESelectionService.class);
        selectionService.addSelectionListener((ISelectionListener)listener);
        selectionService.setSelection(new Object());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)listener.success);
        listener.reset();
        selectionService.setSelection(new Object());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)listener.success);
    }

    @Test
    public void testBug393137() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(partB);
        window.setSelectedElement((MUIElement)partA);
        this.initialize();
        this.getEngine().createGui((MUIElement)window);
        IEclipseContext windowContext = window.getContext();
        IEclipseContext partContextB = partB.getContext();
        EPartService partService = (EPartService)windowContext.get(EPartService.class);
        partService.activate(partA);
        ESelectionService selectionServiceB = (ESelectionService)partContextB.get(ESelectionService.class);
        Target o = new Target("");
        selectionServiceB.setSelection((Object)o);
        selectionServiceB.setPostSelection((Object)o);
        SelectionListener listener = new SelectionListener();
        SelectionListener postListener = new SelectionListener();
        selectionServiceB.addSelectionListener((ISelectionListener)listener);
        selectionServiceB.addPostSelectionListener((ISelectionListener)postListener);
        partService.activate(partB);
        Assert.assertEquals((long)1L, (long)listener.count);
        Assert.assertEquals((long)1L, (long)postListener.count);
    }

    private void initialize() {
        this.applicationContext.set(MApplication.class, (Object)this.application);
        this.applicationContext.set(UISynchronize.class, (Object)new DisplayUISynchronize(Display.getDefault()));
        this.application.setContext(this.applicationContext);
        UIEventPublisher ep = new UIEventPublisher(this.applicationContext);
        ((Notifier)this.application).eAdapters().add((Object)ep);
        this.applicationContext.set(UIEventPublisher.class, (Object)ep);
    }

    static class Bug343984Listener
    implements ISelectionListener {
        IEclipseContext context;
        int count = 0;
        boolean success = false;

        Bug343984Listener() {
        }

        public void reset() {
            this.count = 0;
            this.success = false;
        }

        public void selectionChanged(MPart part, Object selection) {
            if (this.count > 0) {
                this.success = false;
                return;
            }
            this.success = true;
            ++this.count;
            this.context.get("a");
            this.context.set("a", new Object());
            this.context.get("b");
            this.context.set("b", new Object());
        }
    }

    static class ConsumerPart {
        public Object input;

        ConsumerPart() {
        }

        @Inject
        @Optional
        public void setInput(@Named(value="org.eclipse.ui.selection") Object current) {
            this.input = current;
        }
    }

    static class InjectPart {
        Object selection;

        InjectPart() {
        }

        @Inject
        void setSelection(@Optional @Named(value="org.eclipse.ui.selection") Target selection) {
            this.selection = selection;
        }
    }

    static class ProviderPart
    extends ConsumerPart {
        private ESelectionService selectionService;

        ProviderPart() {
        }

        @Inject
        public void setSelectionService(ESelectionService s) {
            this.selectionService = s;
        }

        public void setSelection(Object selection) {
            this.selectionService.setSelection(selection);
        }
    }

    static class SelectionListener
    implements ISelectionListener {
        private MPart part;
        private Object selection;
        private int count;

        SelectionListener() {
        }

        public void reset() {
            this.part = null;
            this.selection = null;
            this.count = 0;
        }

        public void selectionChanged(MPart part, Object selection) {
            this.part = part;
            this.selection = selection;
            ++this.count;
        }

        public MPart getPart() {
            return this.part;
        }

        public Object getSelection() {
            return this.selection;
        }

        public int getCount() {
            return this.count;
        }
    }

    static class Target {
        String s;

        Target(String s) {
            this.s = s;
        }
    }

    static class TrackingProviderPart
    extends ProviderPart {
        public Object otherSelection;

        TrackingProviderPart() {
        }

        public void setOtherSelection(Object selection) {
            this.otherSelection = selection;
        }
    }

    static class UseSelectionHandler {
        public Object selection;

        UseSelectionHandler() {
        }

        @Execute
        public void execute(@Optional @Named(value="org.eclipse.ui.selection") Object s) {
            this.selection = s;
        }
    }
}

