/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.Category;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.ModelServiceImpl;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.tests.application.HeadlessApplicationElementTest;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class HeadlessApplicationTest
extends HeadlessApplicationElementTest {
    protected MApplication application;
    protected IPresentationEngine renderer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.application = (MApplication)this.applicationElement;
        for (MWindow wbw : this.application.getChildren()) {
            this.createGUI((MUIElement)wbw);
        }
        if (this.needsActiveChildEventHandling()) {
            this.addActiveChildEventHandling();
        }
    }

    @After
    public void tearDown() throws Exception {
        for (MWindow window : this.application.getChildren()) {
            this.renderer.removeGui((MUIElement)window);
        }
    }

    protected boolean needsActiveChildEventHandling() {
        return true;
    }

    private void addActiveChildEventHandling() {
    }

    @Test
    public void testGet_ActiveContexts() throws Exception {
        IEclipseContext context = this.application.getContext();
        Assert.assertNotNull((Object)context.get("activeContexts"));
    }

    @Test
    public void testGet_Selection() throws Exception {
        IEclipseContext context = this.application.getContext();
        Assert.assertNull((Object)context.get("org.eclipse.ui.selection"));
    }

    @Test
    public void testGet_ActiveChild() throws Exception {
        IEclipseContext context = this.application.getContext();
        Assert.assertNull((Object)context.getActiveChild());
    }

    @Test
    public void testGet_ActivePart() throws Exception {
        IEclipseContext context = this.application.getContext();
        Assert.assertNull((Object)context.get("e4ActivePart"));
    }

    @Test
    public void test_SwitchActivePartsInContext() throws Exception {
        IEclipseContext context = this.application.getContext();
        MPart[] parts = this.getTwoParts();
        context.set("e4ActivePart", (Object)parts[0]);
        Assert.assertNull((Object)this.getRoot(context).get("e4ActivePart"));
        context.set("e4ActivePart", (Object)parts[1]);
        Assert.assertNull((Object)this.getRoot(context).get("e4ActivePart"));
    }

    private IEclipseContext getRoot(IEclipseContext context) {
        IEclipseContext root = context;
        while ((context = context.getParent()) != null) {
            root = context;
        }
        return root;
    }

    private void test_GetContext(MContext context) {
        Assert.assertNotNull((Object)context.getContext());
    }

    @Test
    public void testGetFirstPart_GetContext() {
        this.getFirstPart().getParent().setSelectedElement((MUIElement)this.getFirstPart());
        this.test_GetContext((MContext)this.getFirstPart());
    }

    @Test
    public void testGetSecondPart_GetContext() {
        this.getSecondPart().getParent().setSelectedElement((MUIElement)this.getSecondPart());
        this.test_GetContext((MContext)this.getSecondPart());
    }

    private void testModify(MContext mcontext) {
        Set<String> variables = HeadlessApplicationTest.getVariables(mcontext, new HashSet<String>());
        IEclipseContext context = mcontext.getContext();
        for (String variable : variables) {
            Object newValue = new Object();
            context.modify(variable, newValue);
            Assert.assertEquals((Object)newValue, (Object)context.get(variable));
        }
    }

    @Test
    public void testModify() {
        this.testGetFirstPart_GetContext();
        this.testModify((MContext)this.getFirstPart());
    }

    @Test
    public void testModify2() {
        this.testGetSecondPart_GetContext();
        this.testModify((MContext)this.getSecondPart());
    }

    private static Set<String> getVariables(MContext context, Set<String> variables) {
        variables.addAll(context.getVariables());
        if (context instanceof MUIElement) {
            MUIElement c = (MUIElement)context;
            MElementContainer parent = c.getParent();
            while (parent != null) {
                if (parent instanceof MContext) {
                    MContext mc = (MContext)parent;
                    HeadlessApplicationTest.getVariables(mc, variables);
                }
                parent = parent.getParent();
            }
        }
        return variables;
    }

    protected MPart[] getTwoParts() {
        MPart firstPart = this.getFirstPart();
        Assert.assertNotNull((Object)firstPart);
        MPart secondPart = this.getSecondPart();
        Assert.assertNotNull((Object)secondPart);
        Assert.assertFalse((boolean)firstPart.equals(secondPart));
        return new MPart[]{firstPart, secondPart};
    }

    protected abstract MPart getFirstPart();

    protected abstract MPart getSecondPart();

    protected void createGUI(MUIElement uiRoot) {
        this.renderer.createGui(uiRoot);
    }

    @Override
    protected MApplicationElement createApplicationElement(IEclipseContext appContext) throws Exception {
        return this.createApplication(appContext, this.getURI());
    }

    protected abstract String getURI();

    protected IPresentationEngine createPresentationEngine(String renderingEngineURI) throws Exception {
        IContributionFactory contributionFactory = (IContributionFactory)this.rule.getApplicationContext().get(IContributionFactory.class);
        Object newEngine = contributionFactory.create(renderingEngineURI, this.rule.getApplicationContext());
        return (IPresentationEngine)newEngine;
    }

    private MApplication createApplication(IEclipseContext appContext, String appURI) throws Exception {
        URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)appURI, (boolean)true);
        ResourceSetImpl set = new ResourceSetImpl();
        set.getPackageRegistry().put((Object)"http://MApplicationPackage/", (Object)ApplicationPackageImpl.eINSTANCE);
        Resource resource = set.getResource(initialWorkbenchDefinitionInstance, true);
        MApplication application = (MApplication)resource.getContents().get(0);
        application.setContext(appContext);
        appContext.set(MApplication.class, (Object)application);
        appContext.set(EModelService.class, (Object)new ModelServiceImpl(appContext));
        ECommandService cs = (ECommandService)appContext.get(ECommandService.class);
        Category cat = cs.defineCategory(MApplication.class.getName(), "Application Category", null);
        List commands = application.getCommands();
        for (MCommand cmd : commands) {
            String id = cmd.getElementId();
            String name = cmd.getCommandName();
            cs.defineCommand(id, name, null, cat, null);
        }
        List windows = application.getChildren();
        for (MWindow window : windows) {
            E4Workbench.initializeContext((IEclipseContext)appContext, (MContext)window);
        }
        this.processPartContributions(application.getContext(), resource);
        this.renderer = this.createPresentationEngine(this.getEngineURI());
        return application;
    }

    protected String getEngineURI() {
        return "bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.application.HeadlessContextPresentationEngine";
    }

    private void processPartContributions(IEclipseContext context, Resource resource) {
        IConfigurationElement[] parts;
        IExtensionRegistry registry = (IExtensionRegistry)context.get(IExtensionRegistry.class);
        String extId = "org.eclipse.e4.workbench.parts";
        IConfigurationElement[] iConfigurationElementArray = parts = registry.getConfigurationElementsFor(extId);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement p = iConfigurationElementArray[n2];
            MPart part = (MPart)this.ems.createModelElement(MPart.class);
            part.setLabel(p.getAttribute("label"));
            part.setIconURI("platform:/plugin/" + p.getContributor().getName() + "/" + p.getAttribute("icon"));
            part.setContributionURI("bundleclass://" + p.getContributor().getName() + "/" + p.getAttribute("class"));
            String parentId = p.getAttribute("parentId");
            EObject parent = this.findObject((TreeIterator<EObject>)resource.getAllContents(), parentId);
            if (parent instanceof MElementContainer) {
                ((MElementContainer)parent).getChildren().add(part);
            }
            ++n2;
        }
    }

    private EObject findObject(TreeIterator<EObject> it, String id) {
        while (it.hasNext()) {
            EObject el = (EObject)it.next();
            if (!(el instanceof MApplicationElement) || !el.eResource().getURIFragment(el).equals(id)) continue;
            return el;
        }
        return null;
    }

    protected MApplicationElement findElement(String id) {
        return this.findElement((MElementContainer<?>)this.application, id);
    }

    private MApplicationElement findElement(MElementContainer<?> container, String id) {
        if (id.equals(container.getElementId())) {
            return container;
        }
        List children = container.getChildren();
        for (Object child : children) {
            MApplicationElement element = (MApplicationElement)child;
            if (element instanceof MElementContainer) {
                MElementContainer c = (MElementContainer)element;
                MApplicationElement found = this.findElement(c, id);
                if (found == null) continue;
                return found;
            }
            if (!id.equals(element.getElementId())) continue;
            return element;
        }
        return null;
    }
}

