/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.Policy;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EObject;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class HeadlessContextPresentationEngine
implements IPresentationEngine {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IContributionFactory contributionFactory;
    private EventHandler childHandler;
    private EventHandler activeChildHandler;
    private EventHandler toBeRenderedHandler;
    private final Map<MUIElement, List<MPlaceholder>> renderedPlaceholders = new HashMap<MUIElement, List<MPlaceholder>>();
    private boolean createContributions = true;
    @Inject
    private EModelService modelService;

    protected IEclipseContext getParentContext(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            if (Policy.DEBUG_CONTEXTS) {
                Activator.trace((String)"/trace/eclipse.context", (String)("Adding " + intf.getName() + " for " + contextModel.getClass().getName()), null);
            }
            context.set(intf.getName(), (Object)contextModel);
            HeadlessContextPresentationEngine.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }

    @PostConstruct
    void postConstruct() {
        this.childHandler = event -> {
            if (UIEvents.isADD((Event)event)) {
                for (Object element : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                    MContext c;
                    IEclipseContext context;
                    if (!(element instanceof MUIElement)) continue;
                    MUIElement e = (MUIElement)element;
                    Object parent = event.getProperty("ChangedElement");
                    IEclipseContext parentContext = this.getParentContext(e);
                    if (element instanceof MContext && (context = (c = (MContext)element).getContext()) != null && context.getParent() != parentContext) {
                        context.deactivate();
                    }
                    this.createGui(e, parent, parentContext);
                    if (!(parent instanceof MPartStack)) continue;
                    MPartStack stack = (MPartStack)parent;
                    List children = stack.getChildren();
                    MStackElement stackElement = (MStackElement)element;
                    if (children.size() != 1 || !stackElement.isVisible() || !stackElement.isToBeRendered()) continue;
                    stack.setSelectedElement((MUIElement)stackElement);
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.childHandler);
        this.activeChildHandler = event -> {
            Object element = event.getProperty("NewValue");
            if (element instanceof MUIElement) {
                MUIElement uiElement = (MUIElement)element;
                Object parent = event.getProperty("ChangedElement");
                if (parent instanceof MGenericStack) {
                    IEclipseContext parentContext = this.getParentContext(uiElement);
                    this.createGui(uiElement, parent, parentContext);
                    if (parent instanceof MPerspectiveStack) {
                        MPerspective perspective = (MPerspective)uiElement;
                        this.adjustPlaceholders((MUIElement)perspective);
                        ((EPartService)parentContext.get(EPartService.class)).switchPerspective(perspective);
                    }
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this.activeChildHandler);
        this.toBeRenderedHandler = event -> {
            MUIElement element = (MUIElement)event.getProperty("ChangedElement");
            Boolean value = (Boolean)event.getProperty("NewValue");
            if (value.booleanValue()) {
                this.createGui(element);
            } else {
                this.removeGui(element);
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.toBeRenderedHandler);
    }

    @PreDestroy
    void preDestroy() {
        this.eventBroker.unsubscribe(this.childHandler);
        this.eventBroker.unsubscribe(this.activeChildHandler);
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
    }

    private void adjustPlaceholders(MUIElement element) {
        if (element.isToBeRendered()) {
            MPlaceholder placeholder;
            MUIElement ref;
            if (element instanceof MPlaceholder && (ref = (placeholder = (MPlaceholder)element).getRef()) != null) {
                ref.setCurSharedRef(placeholder);
                element = ref;
            }
            if (element instanceof MGenericStack) {
                MGenericStack stack = (MGenericStack)element;
                MUIElement selectedElement = stack.getSelectedElement();
                if (selectedElement != null) {
                    this.adjustPlaceholders(selectedElement);
                }
            } else if (element instanceof MElementContainer) {
                MElementContainer container = (MElementContainer)element;
                for (Object child : container.getChildren()) {
                    this.adjustPlaceholders((MUIElement)child);
                }
            }
        }
    }

    public void setCreateContributions(boolean createContributions) {
        this.createContributions = createContributions;
    }

    public Object createGui(MUIElement element, Object parentWidget, IEclipseContext parentContext) {
        MPlaceholder placeholder;
        MUIElement ref;
        Object current = element;
        while (current != null) {
            if (!current.isToBeRendered()) {
                return null;
            }
            current = current.getCurSharedRef() != null ? current.getCurSharedRef() : current.getParent();
        }
        MElementContainer parent = element.getParent();
        if (element.getCurSharedRef() != null) {
            parent = element.getCurSharedRef().getParent();
        }
        if (!(parent instanceof MApplication)) {
            Assert.isNotNull((Object)parentWidget);
        }
        if (element.getWidget() != null) {
            MContext c;
            IEclipseContext context;
            if (element instanceof MContext && (context = (c = (MContext)element).getContext()).getParent() != parentContext) {
                context.setParent(parentContext);
            }
            return element.getWidget();
        }
        element.setRenderer((Object)this);
        Object widget = new Object();
        element.setWidget(widget);
        if (element instanceof MContext) {
            MContext mcontext = (MContext)element;
            IEclipseContext createdContext = mcontext.getContext();
            if (createdContext == null) {
                String contextName = element.getClass().getInterfaces()[0].getName() + " eclipse context";
                createdContext = parentContext != null ? parentContext.createChild(contextName) : EclipseContextFactory.create((String)contextName);
                HeadlessContextPresentationEngine.populateModelInterfaces(mcontext, createdContext, element.getClass().getInterfaces());
                for (String variable : mcontext.getVariables()) {
                    createdContext.declareModifiable(variable);
                }
                mcontext.setContext(createdContext);
                if (element instanceof MContribution) {
                    Object uri;
                    MContribution contribution = (MContribution)element;
                    if (this.createContributions && (uri = contribution.getContributionURI()) != null) {
                        Object clientObject = this.contributionFactory.create((String)uri, createdContext);
                        contribution.setObject(clientObject);
                    }
                }
                if (parentContext != null && parentContext.getActiveChild() == null) {
                    createdContext.activate();
                }
            } else if (createdContext.getParent() != parentContext) {
                createdContext.setParent(parentContext);
            }
        }
        if (element instanceof MGenericStack) {
            MGenericStack container = (MGenericStack)element;
            MUIElement active = container.getSelectedElement();
            if (active != null) {
                this.createGui(active, container, this.getParentContext(active));
            } else {
                List children = container.getChildren();
                if (!children.isEmpty()) {
                    ((MElementContainer)element).setSelectedElement((MUIElement)children.get(0));
                }
            }
        } else if (element instanceof MElementContainer) {
            MElementContainer c = (MElementContainer)element;
            for (Object child : c.getChildren()) {
                if (!(child instanceof MUIElement)) continue;
                MUIElement e = (MUIElement)child;
                this.createGui(e, element, this.getParentContext(e));
                if (!(child instanceof MContext)) continue;
                MContext mc = (MContext)child;
                IEclipseContext childContext = mc.getContext();
                IEclipseContext pContext = this.getParentContext(e);
                if (childContext == null || pContext.getActiveChild() != null) continue;
                childContext.activate();
            }
            if (element instanceof MWindow) {
                MWindow window = (MWindow)element;
                for (MWindow childWindow : window.getWindows()) {
                    this.createGui((MUIElement)childWindow, element, window.getContext());
                }
            }
            if (element instanceof MPerspective) {
                MPerspective perspective = (MPerspective)element;
                for (MWindow childWindow : perspective.getWindows()) {
                    this.createGui((MUIElement)childWindow, element, perspective.getContext());
                }
            }
        } else if (element instanceof MPlaceholder && (ref = (placeholder = (MPlaceholder)element).getRef()) != null) {
            ref.setCurSharedRef(placeholder);
            ref.setToBeRendered(true);
            this.createGui(ref);
            List<MPlaceholder> placeholders = this.renderedPlaceholders.get(ref);
            if (placeholders == null) {
                placeholders = new ArrayList<MPlaceholder>();
                this.renderedPlaceholders.put(ref, placeholders);
            } else if (placeholders.contains(placeholder)) {
                return null;
            }
            placeholders.add(placeholder);
        }
        return widget;
    }

    public Object createGui(MUIElement element) {
        MPlaceholder placeholder = element.getCurSharedRef();
        if (placeholder != null) {
            return this.createGui(element, placeholder.getWidget(), this.getParentContext(element));
        }
        MElementContainer parent = element.getParent();
        if (parent == null) {
            parent = (MUIElement)((EObject)element).eContainer();
        }
        return this.createGui(element, parent.getWidget(), this.getParentContext(element));
    }

    public void removeGui(MUIElement element) {
        if (element instanceof MElementContainer) {
            MElementContainer c = (MElementContainer)element;
            for (Object child : c.getChildren()) {
                if (!(child instanceof MUIElement)) continue;
                MUIElement e = (MUIElement)child;
                this.removeGui(e);
            }
        }
        if (element instanceof MPlaceholder) {
            MPlaceholder p = (MPlaceholder)element;
            this.removePlaceholder(p);
        }
        if (element instanceof MContext) {
            IEclipseContext parentContext;
            MContext mcontext = (MContext)element;
            IEclipseContext context = mcontext.getContext();
            if (context != null && (parentContext = context.getParent()) != null && parentContext.getActiveChild() == context) {
                context.deactivate();
            }
            mcontext.setContext(null);
            if (context != null) {
                context.dispose();
            }
        }
        element.setRenderer(null);
        element.setWidget(null);
    }

    private void removePlaceholder(MPlaceholder placeholder) {
        MUIElement ref = placeholder.getRef();
        List<MPlaceholder> placeholders = this.renderedPlaceholders.get(placeholder.getRef());
        placeholders.remove(placeholder);
        if (placeholders.isEmpty()) {
            this.removeGui(ref);
            this.renderedPlaceholders.remove(ref);
        } else {
            IEclipseContext currentContext = this.modelService.getContainingContext((MUIElement)placeholder);
            for (MPlaceholder other : placeholders) {
                IEclipseContext newParentContext = this.modelService.getContainingContext((MUIElement)other);
                if (newParentContext == null) continue;
                List contextElements = this.modelService.findElements(ref, null, MContext.class);
                for (MContext contextElement : contextElements) {
                    IEclipseContext context = contextElement.getContext();
                    if (context.getParent() != currentContext) continue;
                    context.setParent(newParentContext);
                }
                ref.setCurSharedRef(other);
                break;
            }
        }
    }

    public Object run(MApplicationElement uiRoot, IEclipseContext appContext) {
        return 0;
    }

    public void stop() {
    }

    public void focusGui(MUIElement element) {
        Object defaultValue;
        IEclipseContext context;
        Object returnValue;
        Object implementation;
        if (element instanceof MContribution) {
            MContribution c = (MContribution)element;
            v0 = c.getObject();
        } else {
            v0 = implementation = null;
        }
        if (implementation != null && (returnValue = ContextInjectionFactory.invoke((Object)implementation, Focus.class, (IEclipseContext)(context = this.getContext(element)), (Object)(defaultValue = new Object()))) == defaultValue) {
            System.err.println("No @Focus method");
        }
    }

    private IEclipseContext getContext(MUIElement parent) {
        if (parent instanceof MContext) {
            MContext c = (MContext)parent;
            return c.getContext();
        }
        return this.modelService.getContainingContext(parent);
    }
}

