/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.junit.Assert;
import org.junit.Test;

public class ModelElementTest {
    @Test
    public void testForMApplicationInterface() {
        ArrayList<EClass> failedClasses = new ArrayList<EClass>();
        this.checkPackageForMApplicationInterface(failedClasses, (EPackage)ApplicationPackageImpl.eINSTANCE);
        if (failedClasses.size() > 0) {
            StringBuilder b = new StringBuilder("The following concrete classes don't implement 'MApplicationElement':\n");
            for (EClass c : failedClasses) {
                b.append("* " + c.getName() + "\n");
            }
            System.err.println(b.toString());
            Assert.fail((String)b.toString());
        }
    }

    private void checkPackageForMApplicationInterface(List<EClass> failedClasses, EPackage ePackage) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            EClass c;
            if (!(classifier instanceof EClass) || (c = (EClass)classifier).isInterface() || c == ApplicationPackageImpl.Literals.STRING_TO_STRING_MAP || c == ApplicationPackageImpl.Literals.STRING_TO_OBJECT_MAP || MApplicationElement.class.isAssignableFrom(c.getInstanceClass())) continue;
            failedClasses.add(c);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.checkPackageForMApplicationInterface(failedClasses, subPackage);
        }
    }

    @Test
    public void testForOptimalBaseClass() {
        LinkedHashMap<EClass, EClass> failedClasses = new LinkedHashMap<EClass, EClass>();
        this.checkPackageForOptimalBaseClass(failedClasses, (EPackage)ApplicationPackageImpl.eINSTANCE);
        if (failedClasses.size() > 0) {
            StringBuilder b = new StringBuilder("The following concrete classes have a sub-optimal first super type:\n");
            for (Map.Entry entry : failedClasses.entrySet()) {
                EClass c = (EClass)entry.getKey();
                EClass actualESuperType = (EClass)c.getESuperTypes().get(0);
                EClass bestESuperType = (EClass)entry.getValue();
                b.append("* " + c.getName() + " extends " + actualESuperType.getName() + " with " + this.getReusedGeneratedFeatureCount(actualESuperType) + " reused features  instead of " + bestESuperType.getName() + " with " + this.getReusedGeneratedFeatureCount(bestESuperType) + " reused features\n");
            }
            System.err.println(b.toString());
            Assert.fail((String)b.toString());
        }
    }

    private void checkPackageForOptimalBaseClass(Map<EClass, EClass> failedClasses, EPackage ePackage) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (classifier == UiPackageImpl.Literals.IMPERATIVE_EXPRESSION || classifier == MenuPackageImpl.Literals.HANDLED_MENU_ITEM || classifier == MenuPackageImpl.Literals.HANDLED_TOOL_ITEM || !(classifier instanceof EClass)) continue;
            EClass c = (EClass)classifier;
            EList eSuperTypes = c.getESuperTypes();
            int bestReusedGeneratedFeatureCount = 0;
            EClass bestESuperType = null;
            for (EClass eSuperType : eSuperTypes) {
                int reusedGeneratedFeatureCount = this.getReusedGeneratedFeatureCount(eSuperType);
                if (reusedGeneratedFeatureCount <= bestReusedGeneratedFeatureCount) continue;
                bestESuperType = eSuperType;
                bestReusedGeneratedFeatureCount = reusedGeneratedFeatureCount;
            }
            if (bestESuperType == null || eSuperTypes.indexOf(bestESuperType) == 0) continue;
            failedClasses.put(c, bestESuperType);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.checkPackageForOptimalBaseClass(failedClasses, subPackage);
        }
    }

    private int getReusedGeneratedFeatureCount(EClass eClass) {
        if (eClass.isInterface()) {
            EList eSuperTypes = eClass.getESuperTypes();
            if (!eSuperTypes.isEmpty()) {
                return this.getReusedGeneratedFeatureCount((EClass)eSuperTypes.get(0));
            }
            return 0;
        }
        return eClass.getEAllStructuralFeatures().size();
    }
}

