/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.ResourceHandler;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.swt.DisplayUISynchronize;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class ResourceHandlerTest {
    private ServiceTracker locationTracker;
    private MApplication application;
    private Resource resource;

    public Location getInstanceLocation() {
        if (this.locationTracker == null) {
            BundleContext context = FrameworkUtil.getBundle(ResourceHandlerTest.class).getBundleContext();
            Filter filter = null;
            try {
                filter = context.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            this.locationTracker = new ServiceTracker(context, filter, null);
            this.locationTracker.open();
        }
        return (Location)this.locationTracker.getService();
    }

    private ResourceHandler createHandler(URI uri) {
        IEclipseContext appContext = E4Application.createDefaultContext();
        IEclipseContext localContext = appContext.createChild();
        localContext.set("instanceLocation", (Object)this.getInstanceLocation());
        localContext.set("persistState", (Object)Boolean.TRUE);
        localContext.set("clearPersistedState", (Object)Boolean.TRUE);
        localContext.set("initialWorkbenchModelURI", (Object)uri);
        localContext.set(UISynchronize.class, (Object)new DisplayUISynchronize(Display.getDefault()));
        return (ResourceHandler)ContextInjectionFactory.make(ResourceHandler.class, (IEclipseContext)localContext);
    }

    @Before
    public void setup() {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.e4.ui.tests/xmi/modelprocessor/base.e4xmi", (boolean)true);
        ResourceHandler handler = this.createHandler(uri);
        this.resource = handler.loadMostRecentModel();
        this.application = (MApplication)this.resource.getContents().get(0);
    }

    @Test
    public void testProcessedApplicationModelNotNull() {
        Assert.assertNotNull((Object)this.application);
    }

    @Test
    public void testModelProcessor() {
        Assert.assertEquals((long)2L, (long)this.application.getChildren().size());
        MWindow mWindow2 = (MWindow)this.application.getChildren().get(1);
        Assert.assertEquals((Object)"fragment.contributedWindow", (Object)mWindow2.getElementId());
        Assert.assertEquals((Object)"_w4fQ8HVHEd-aXt9fFntEtw", (Object)((E4XMIResource)this.resource).getID((EObject)mWindow2));
        MWindowElement mWindowElement = (MWindowElement)mWindow2.getChildren().get(0);
        Assert.assertEquals((Object)"_rdlLgJQUEd-6X_lmWgGEDA", (Object)((E4XMIResource)this.resource).getID((EObject)mWindowElement));
        Assert.assertEquals((Object)"platform:/plugin/org.eclipse.e4.ui.tests", (Object)mWindow2.getContributorURI());
        Assert.assertEquals((Object)"platform:/plugin/org.eclipse.e4.ui.tests", (Object)mWindowElement.getContributorURI());
        List handlers = this.application.getHandlers();
        if (handlers.size() > 2) {
            String check = "bundleclass://org.eclipse.e4.tools.emf.liveeditor/org.eclipse.e4.tools.emf.liveeditor.OpenLiveDialogHandler";
            if (check.equals(((MHandler)handlers.get(0)).getContributionURI())) {
                handlers.remove(0);
            } else if (check.equals(((MHandler)handlers.get(1)).getContributionURI())) {
                handlers.remove(1);
            }
        }
        Assert.assertTrue((handlers.size() > 0 ? 1 : 0) != 0);
        List commands = this.application.getCommands();
        MCommand expected = (MCommand)commands.get(0);
        long count = handlers.stream().filter(x -> x.getCommand() == expected).count();
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((long)2L, (long)expected.getParameters().size());
        Assert.assertEquals((long)1L, (long)mWindow2.getVariables().size());
        MWindow mWindow1 = (MWindow)this.application.getChildren().get(0);
        Assert.assertNotNull((Object)mWindow1.getMainMenu());
        List children = mWindow1.getChildren();
        Assert.assertEquals((long)8L, (long)children.size());
        Assert.assertEquals((Object)"fragment.contributedPosFirst", (Object)((MWindowElement)children.get(0)).getElementId());
        Assert.assertEquals((Object)"fragment.contributedBeforePart1", (Object)((MWindowElement)children.get(1)).getElementId());
        Assert.assertEquals((Object)"fragment.contributedAfterPart1", (Object)((MWindowElement)children.get(3)).getElementId());
        Assert.assertEquals((Object)"fragment.contributedPos1", (Object)((MWindowElement)children.get(4)).getElementId());
        Assert.assertEquals((Object)"fragment.contributedBeforePart2", (Object)((MWindowElement)children.get(5)).getElementId());
        Assert.assertEquals((Object)"fragment.contributedAfterPart2", (Object)((MWindowElement)children.get(7)).getElementId());
    }

    @Test
    public void testXPathModelProcessor() {
        MMenu mainMenu = ((MWindow)this.application.getChildren().get(0)).getMainMenu();
        Assert.assertNotNull((Object)mainMenu);
        MMenu menu1 = (MMenu)this.findByElementId(mainMenu.getChildren(), "fragment.contributedMenu1");
        Assert.assertNotNull((Object)menu1);
        MMenu menu2 = (MMenu)this.findByElementId(mainMenu.getChildren(), "fragment.contributedMenu2");
        Assert.assertNotNull((Object)menu2);
        Assert.assertNotNull((Object)this.findByElementId(menu1.getChildren(), "fragment.contributedMenuItem.csv"));
        Assert.assertNotNull((Object)this.findByElementId(menu2.getChildren(), "fragment.contributedMenuItem.csv"));
        Assert.assertNotNull((Object)this.findByElementId(menu1.getChildren(), "fragment.contributedMenuItem.xpath"));
        Assert.assertNotNull((Object)this.findByElementId(menu2.getChildren(), "fragment.contributedMenuItem.xpath"));
    }

    private Object findByElementId(List<MMenuElement> children, String id) {
        for (MMenuElement item : children) {
            if (!id.equals(item.getElementId())) continue;
            return item;
        }
        return null;
    }

    @Test
    public void testDynamicElementsDoNotGetPersisted() throws IOException {
        URI uri = URI.createPlatformPluginURI((String)"org.eclipse.e4.ui.tests/xmi/modelprocessor/base.e4xmi", (boolean)true);
        ResourceHandler handler = this.createHandler(uri);
        Resource resource = handler.loadMostRecentModel();
        MApplication application = (MApplication)resource.getContents().get(0);
        Assert.assertNotNull((Object)application);
        Assert.assertEquals((long)2L, (long)application.getChildren().size());
        MWindow dynamicWindow = MBasicFactory.INSTANCE.createWindow();
        dynamicWindow.setLabel("Dynamically generated window");
        application.getChildren().add(dynamicWindow);
        Path changedOutput = Files.createTempFile(null, null, new FileAttribute[0]);
        changedOutput.toFile().deleteOnExit();
        URI changedUri = URI.createFileURI((String)changedOutput.toString());
        resource.setURI(changedUri);
        handler.save();
        ResourceHandler verifyHandler = this.createHandler(changedUri);
        Resource verifyResource = verifyHandler.loadMostRecentModel();
        MApplication changedApplication = (MApplication)verifyResource.getContents().get(0);
        Assert.assertEquals((long)3L, (long)changedApplication.getChildren().size());
        dynamicWindow.getPersistedState().put("persistState", "false");
        Path unchangedOutput = Files.createTempFile(null, null, new FileAttribute[0]);
        unchangedOutput.toFile().deleteOnExit();
        URI unchangedUri = URI.createFileURI((String)unchangedOutput.toString());
        resource.setURI(unchangedUri);
        handler.save();
        verifyHandler = this.createHandler(unchangedUri);
        verifyResource = verifyHandler.loadMostRecentModel();
        MApplication unchangedApplication = (MApplication)verifyResource.getContents().get(0);
        Assert.assertEquals((long)2L, (long)unchangedApplication.getChildren().size());
    }
}

