/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.Arrays;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.tests.application.HeadlessApplicationElementTest;
import org.eclipse.emf.common.util.EList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.service.event.Event;

public class UIEventTypesTest
extends HeadlessApplicationElementTest {
    private Event event;
    private int eventCount;

    @Override
    protected MApplicationElement createApplicationElement(IEclipseContext appContext) throws Exception {
        return MApplicationFactory.INSTANCE.createApplication();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        IEventBroker appEB = (IEventBroker)this.rule.getApplicationContext().get(IEventBroker.class);
        this.eventCount = 0;
        appEB.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*", event -> {
            ++this.eventCount;
            this.event = event;
        });
        appEB.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/elementId/*", event -> {
            ++this.eventCount;
            this.event = event;
        });
    }

    @Test
    public void testAdd() {
        this.applicationElement.getTags().add("0");
        Assert.assertEquals((long)1L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        Assert.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        Assert.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        Assert.assertEquals((Object)"ADD", (Object)this.event.getProperty("EventType"));
        Assert.assertEquals((Object)0, (Object)this.event.getProperty("Position"));
        Assert.assertEquals(null, (Object)this.event.getProperty("OldValue"));
        Assert.assertEquals((Object)"0", (Object)this.event.getProperty("NewValue"));
    }

    @Test
    public void testAddMany() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        Assert.assertEquals((long)1L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        Assert.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        Assert.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        Assert.assertEquals((Object)"ADD_MANY", (Object)this.event.getProperty("EventType"));
        Assert.assertEquals((Object)0, (Object)this.event.getProperty("Position"));
        Assert.assertEquals(null, (Object)this.event.getProperty("OldValue"));
        Assert.assertEquals(Arrays.asList("0", "1", "2"), (Object)this.event.getProperty("NewValue"));
    }

    @Test
    public void testRemove() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        Assert.assertEquals((long)1L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        this.event = null;
        this.applicationElement.getTags().remove("1");
        Assert.assertEquals((long)2L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        Assert.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        Assert.assertEquals((Object)1, (Object)this.event.getProperty("Position"));
        Assert.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        Assert.assertEquals((Object)"REMOVE", (Object)this.event.getProperty("EventType"));
        Assert.assertEquals((Object)"1", (Object)this.event.getProperty("OldValue"));
        Assert.assertEquals(null, (Object)this.event.getProperty("NewValue"));
    }

    @Test
    public void testRemoveMany() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        Assert.assertEquals((long)1L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        this.event = null;
        this.applicationElement.getTags().removeAll(Arrays.asList("2", "0"));
        Assert.assertEquals((long)2L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        Assert.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        Assert.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        Assert.assertEquals((Object)"REMOVE_MANY", (Object)this.event.getProperty("EventType"));
        Assert.assertEquals(Arrays.asList("0", "2"), (Object)this.event.getProperty("OldValue"));
        Assert.assertTrue((boolean)(this.event.getProperty("Position") instanceof int[]));
        int[] removedPositions = (int[])this.event.getProperty("Position");
        Assert.assertEquals((long)0L, (long)removedPositions[0]);
        Assert.assertEquals((long)2L, (long)removedPositions[1]);
    }

    @Test
    public void testRetain() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        Assert.assertEquals((long)1L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        this.event = null;
        this.applicationElement.getTags().retainAll(Arrays.asList("0"));
        Assert.assertEquals((long)3L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        Assert.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        Assert.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        Assert.assertEquals((Object)"REMOVE", (Object)this.event.getProperty("EventType"));
    }

    @Test
    public void testClear() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        Assert.assertEquals((long)1L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        this.event = null;
        this.applicationElement.getTags().clear();
        Assert.assertEquals((long)2L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        Assert.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        Assert.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        Assert.assertEquals((Object)"REMOVE_MANY", (Object)this.event.getProperty("EventType"));
        Assert.assertEquals(Arrays.asList("0", "1", "2"), (Object)this.event.getProperty("OldValue"));
        Assert.assertEquals(null, (Object)this.event.getProperty("NewValue"));
        Assert.assertEquals(null, (Object)this.event.getProperty("Position"));
    }

    @Test
    public void testMove() {
        this.applicationElement.getTags().addAll(Arrays.asList("0", "1", "2"));
        Assert.assertEquals((long)1L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        this.event = null;
        ((EList)this.applicationElement.getTags()).move(0, 2);
        Assert.assertEquals((long)2L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        Assert.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        Assert.assertEquals((Object)"tags", (Object)this.event.getProperty("AttName"));
        Assert.assertEquals((Object)"MOVE", (Object)this.event.getProperty("EventType"));
        Assert.assertEquals((Object)"2", (Object)this.event.getProperty("NewValue"));
        Assert.assertEquals((String)"former position", (Object)2, (Object)this.event.getProperty("OldValue"));
        Assert.assertEquals((String)"new position", (Object)0, (Object)this.event.getProperty("Position"));
    }

    @Test
    public void testSet() {
        this.applicationElement.setElementId("aaa");
        Assert.assertEquals((long)1L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        Assert.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        Assert.assertEquals((Object)"elementId", (Object)this.event.getProperty("AttName"));
        Assert.assertEquals((Object)"SET", (Object)this.event.getProperty("EventType"));
        Assert.assertEquals(null, (Object)this.event.getProperty("OldValue"));
        Assert.assertEquals((Object)"aaa", (Object)this.event.getProperty("NewValue"));
        this.applicationElement.setElementId(null);
        Assert.assertEquals((long)2L, (long)this.eventCount);
        Assert.assertNotNull((Object)this.event);
        Assert.assertEquals((Object)this.applicationElement, (Object)this.event.getProperty("ChangedElement"));
        Assert.assertEquals((Object)"elementId", (Object)this.event.getProperty("AttName"));
        Assert.assertEquals((Object)"SET", (Object)this.event.getProperty("EventType"));
        Assert.assertEquals((Object)"aaa", (Object)this.event.getProperty("OldValue"));
        Assert.assertEquals(null, (Object)this.event.getProperty("NewValue"));
    }
}

