/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.ArrayList;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.tests.application.HeadlessApplicationElementTest;
import org.eclipse.e4.ui.tests.model.test.MTestFactory;
import org.eclipse.e4.ui.tests.model.test.MTestHarness;
import org.eclipse.emf.common.notify.Notifier;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.event.EventHandler;

public class UIEventsTest
extends HeadlessApplicationElementTest {
    @Override
    protected MApplicationElement createApplicationElement(IEclipseContext appContext) throws Exception {
        MApplication application = MApplicationFactory.INSTANCE.createApplication();
        application.getChildren().add(MBasicFactory.INSTANCE.createWindow());
        return application;
    }

    @Test
    public void testAllTopics() {
        IEventBroker eventBroker = (IEventBroker)this.rule.getApplicationContext().get(IEventBroker.class);
        AppElementTester appTester = new AppElementTester(eventBroker);
        CommandTester commandTester = new CommandTester(eventBroker);
        ContextTester contextTester = new ContextTester(eventBroker);
        ContributionTester contributionTester = new ContributionTester(eventBroker);
        ElementContainerTester elementContainerTester = new ElementContainerTester(eventBroker);
        DirtyableTester dirtyableTester = new DirtyableTester(eventBroker);
        ParameterTester parameterTester = new ParameterTester(eventBroker);
        UIElementTester uiElementTester = new UIElementTester(eventBroker);
        UIItemTester uiItemTester = new UIItemTester(eventBroker);
        WindowTester windowTester = new WindowTester(eventBroker);
        EventTester[] allTesters = new EventTester[]{appTester, commandTester, contextTester, contributionTester, elementContainerTester, parameterTester, uiElementTester, uiItemTester, windowTester};
        MTestHarness allData = MTestFactory.eINSTANCE.createTestHarness();
        UIEventPublisher ep = new UIEventPublisher(this.rule.getApplicationContext());
        ((Notifier)allData).eAdapters().add((Object)ep);
        this.rule.getApplicationContext().set(UIEventPublisher.class, (Object)ep);
        this.reset(allTesters);
        String newId = "Some New Id";
        allData.setElementId(newId);
        allData.getTags().add("Testing");
        allData.getPersistedState().put("testing", "Some state");
        this.checkForFailures(allTesters, appTester);
        appTester.reset();
        allData.setElementId(newId);
        Assert.assertTrue((String)"event thrown on No-Op", (appTester.getAttIds(true).length == 0 ? 1 : 0) != 0);
        this.reset(allTesters);
        IEclipseContext newContext = EclipseContextFactory.create();
        allData.setContext(newContext);
        allData.getVariables().add("foo");
        this.checkForFailures(allTesters, contextTester);
        this.reset(allTesters);
        allData.setContext(EclipseContextFactory.create());
        allData.getVariables().add("A var");
        this.checkForFailures(allTesters, contextTester);
        this.reset(allTesters);
        allData.setContributionURI("Some URI");
        allData.setObject("Some onbject");
        this.checkForFailures(allTesters, contributionTester);
        this.reset(allTesters);
        MMenu menu = MMenuFactory.INSTANCE.createMenu();
        allData.getChildren().add(menu);
        allData.setSelectedElement((MUIElement)menu);
        this.checkForFailures(allTesters, elementContainerTester);
        this.reset(allTesters);
        allData.setDirty(!allData.isDirty());
        this.checkForFailures(allTesters, dirtyableTester);
        this.reset(allTesters);
        allData.setName("New Tag");
        allData.setValue("New Value");
        this.checkForFailures(allTesters, parameterTester);
        this.reset(allTesters);
        MTestHarness newParent = MTestFactory.eINSTANCE.createTestHarness();
        allData.setRenderer("New Renderer");
        allData.setParent(newParent);
        allData.setToBeRendered(!allData.isToBeRendered());
        allData.setVisible(!allData.isVisible());
        allData.setOnTop(!allData.isOnTop());
        allData.setWidget("New Widget");
        allData.setContainerData("new Data");
        this.checkForFailures(allTesters, uiElementTester);
        this.reset(allTesters);
        allData.setLabel("New Name");
        allData.setIconURI("New Icon URI");
        allData.setTooltip("New Tooltip");
        this.checkForFailures(allTesters, uiItemTester);
        this.reset(allTesters);
        MWindow window = (MWindow)((MApplication)this.applicationElement).getChildren().get(0);
        window.setX(1234);
        window.setY(1234);
        window.setWidth(1234);
        window.setHeight(1234);
        MMenu newMainMenu = MMenuFactory.INSTANCE.createMenu();
        window.setMainMenu(newMainMenu);
        this.checkForFailures(allTesters, windowTester);
    }

    @Test
    public void testBrokerCleanup() {
        String testTopic = "test/374534";
        IEventBroker appEB = (IEventBroker)this.rule.getApplicationContext().get(IEventBroker.class);
        IEclipseContext childContext = this.rule.getApplicationContext().createChild();
        IEventBroker childEB = (IEventBroker)childContext.get(IEventBroker.class);
        Assert.assertNotEquals((String)"child context has same IEventBroker", (Object)appEB, (Object)childEB);
        boolean[] seen = new boolean[1];
        childEB.subscribe("test/374534", event -> {
            boolean bl = blArray[0] = true;
        });
        Assert.assertFalse((boolean)seen[0]);
        appEB.send("test/374534", null);
        Assert.assertTrue((boolean)seen[0]);
        seen[0] = false;
        childContext.dispose();
        appEB.send("test/374534", null);
        Assert.assertFalse((boolean)seen[0]);
    }

    private void checkForFailures(EventTester[] allTesters, EventTester tester) {
        this.ensureAllSet(tester);
        this.ensureNoCrossTalk(allTesters, tester);
    }

    private void ensureNoCrossTalk(EventTester[] allTesters, EventTester skipMe) {
        ArrayList<EventTester> badTesters = new ArrayList<EventTester>();
        EventTester[] eventTesterArray = allTesters;
        int n = allTesters.length;
        int n2 = 0;
        while (n2 < n) {
            EventTester t = eventTesterArray[n2];
            if (!t.equals(skipMe) && t.getAttIds(true).length > 0) {
                badTesters.add(t);
            }
            ++n2;
        }
        if (!badTesters.isEmpty()) {
            String msg = "Events were fired in the wrong topic(s): " + String.valueOf(badTesters);
            Assert.fail((String)msg);
        }
    }

    private void ensureAllSet(EventTester tester) {
        String[] unfiredIds = tester.getAttIds(false);
        if (unfiredIds.length > 0) {
            StringBuilder msg = new StringBuilder("No event fired:").append(unfiredIds);
            String[] stringArray = unfiredIds;
            int n = unfiredIds.length;
            int n2 = 0;
            while (n2 < n) {
                String unfiredId = stringArray[n2];
                msg.append(' ').append(unfiredId);
                ++n2;
            }
            Assert.fail((String)msg.toString());
        }
    }

    private void reset(EventTester[] allTesters) {
        EventTester[] eventTesterArray = allTesters;
        int n = allTesters.length;
        int n2 = 0;
        while (n2 < n) {
            EventTester t = eventTesterArray[n2];
            t.reset();
            ++n2;
        }
    }

    public static class AppElementTester
    extends EventTester {
        AppElementTester(IEventBroker eventBroker) {
            super("AppElement", "org/eclipse/e4/ui/model/application/ApplicationElement/*", new String[]{"elementId", "tags", "persistedState"}, eventBroker);
        }
    }

    public static class CommandTester
    extends EventTester {
        CommandTester(IEventBroker eventBroker) {
            super("Command", "org/eclipse/e4/ui/model/commands/Command/*", new String[]{"commandName"}, eventBroker);
        }
    }

    public static class ContextTester
    extends EventTester {
        ContextTester(IEventBroker eventBroker) {
            super("Context", "org/eclipse/e4/ui/model/ui/Context/*", new String[]{"context", "variables"}, eventBroker);
        }
    }

    public static class ContributionTester
    extends EventTester {
        ContributionTester(IEventBroker eventBroker) {
            super("Contribution", "org/eclipse/e4/ui/model/application/Contribution/*", new String[]{"contributionURI", "object"}, eventBroker);
        }
    }

    public static class DirtyableTester
    extends EventTester {
        DirtyableTester(IEventBroker eventBroker) {
            super("Dirtyable", "org/eclipse/e4/ui/model/ui/Dirtyable/*", new String[]{"dirty"}, eventBroker);
        }
    }

    public static class ElementContainerTester
    extends EventTester {
        ElementContainerTester(IEventBroker eventBroker) {
            super("ElementContainer", "org/eclipse/e4/ui/model/ui/ElementContainer/*", new String[]{"children", "selectedElement"}, eventBroker);
        }
    }

    static class EventTester {
        String testerName;
        IEventBroker eventBroker;
        String topic;
        String[] attIds;
        boolean[] hasFired;
        EventHandler attListener = event -> {
            if (this.topic.endsWith("*")) {
                Assert.assertTrue((String)"Incorrect Topic.", (boolean)event.getTopic().startsWith(this.topic.substring(0, this.topic.length() - 2)));
            } else {
                Assert.assertEquals((String)"Incorrect Topic.", (Object)this.topic, (Object)event.getTopic());
            }
            String attId = (String)event.getProperty("AttName");
            int attIndex = this.getAttIndex(attId);
            Assert.assertTrue((String)("Unknown Attribite: " + attId), (attIndex >= 0 ? 1 : 0) != 0);
            this.hasFired[attIndex] = true;
        };

        public EventTester(String name, String topic, String[] attIds, IEventBroker eventBroker) {
            this.testerName = name;
            this.topic = topic;
            this.attIds = attIds;
            this.eventBroker = eventBroker;
            this.hasFired = new boolean[attIds.length];
            this.reset();
            eventBroker.subscribe(this.topic, this.attListener);
        }

        protected int getAttIndex(String attId) {
            int i = 0;
            while (i < this.attIds.length) {
                if (this.attIds[i].equals(attId)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void dispose() {
            this.eventBroker.unsubscribe(this.attListener);
        }

        public void reset() {
            int i = 0;
            while (i < this.hasFired.length) {
                this.hasFired[i] = false;
                ++i;
            }
        }

        public String[] getAttIds(boolean fired) {
            ArrayList<String> atts = new ArrayList<String>();
            int i = 0;
            while (i < this.hasFired.length) {
                if (this.hasFired[i] == fired) {
                    atts.add(this.attIds[i]);
                }
                ++i;
            }
            return atts.toArray(new String[atts.size()]);
        }
    }

    public static class ParameterTester
    extends EventTester {
        ParameterTester(IEventBroker eventBroker) {
            super("Parameter", "org/eclipse/e4/ui/model/commands/Parameter/*", new String[]{"name", "value"}, eventBroker);
        }
    }

    public static class UIElementTester
    extends EventTester {
        UIElementTester(IEventBroker eventBroker) {
            super("UIElement", "org/eclipse/e4/ui/model/ui/UIElement/*", new String[]{"renderer", "toBeRendered", "parent", "onTop", "visible", "containerData", "widget"}, eventBroker);
        }
    }

    public static class UIItemTester
    extends EventTester {
        UIItemTester(IEventBroker eventBroker) {
            super("UIItem", "org/eclipse/e4/ui/model/ui/UILabel/*", new String[]{"label", "iconURI", "tooltip"}, eventBroker);
        }
    }

    public static class WindowTester
    extends EventTester {
        WindowTester(IEventBroker eventBroker) {
            super("Window", "org/eclipse/e4/ui/model/basic/Window/*", new String[]{"mainMenu", "x", "y", "width", "height"}, eventBroker);
        }
    }
}

