/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.rules;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.internal.di.osgi.ProviderHelper;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.swt.DisplayUISynchronize;
import org.eclipse.swt.widgets.Display;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class WorkbenchContextRule
implements MethodRule {
    private IEclipseContext context;
    private E4Workbench wb;

    public void createAndRunWorkbench(MWindow window) {
        if (this.wb == null) {
            this.wb = new E4Workbench((MApplicationElement)this.context.get(MApplication.class), this.context);
        }
        this.wb.createAndRunUI((MApplicationElement)window);
    }

    public void spinEventLoop() {
        while (Display.getDefault().readAndDispatch()) {
        }
    }

    public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                WorkbenchContextRule.this.createContext();
                ContextInjectionFactory.inject((Object)target, (IEclipseContext)WorkbenchContextRule.this.context);
                try {
                    base.evaluate();
                }
                finally {
                    WorkbenchContextRule.this.dispose();
                }
            }
        };
    }

    protected void createContext() throws Throwable {
        this.context = E4Application.createDefaultContext();
        this.context.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        Display display = Display.getDefault();
        this.context.set(UISynchronize.class, (Object)new DisplayUISynchronize(display));
        ContextInjectionFactory.setDefault((IEclipseContext)this.context);
        ExtendedObjectSupplier supplier = ProviderHelper.findProvider((String)UIEventTopic.class.getName(), null);
        ContextInjectionFactory.inject((Object)supplier, (IEclipseContext)this.context);
        EModelService ems = (EModelService)this.context.get(EModelService.class);
        MApplication application = (MApplication)ems.createModelElement(MApplication.class);
        application.setContext(this.context);
        this.context.set(MApplication.class, (Object)application);
    }

    protected void dispose() {
        if (this.wb != null) {
            this.wb.close();
        }
        ContextInjectionFactory.setDefault(null);
        ExtendedObjectSupplier supplier = ProviderHelper.findProvider((String)UIEventTopic.class.getName(), null);
        ContextInjectionFactory.uninject((Object)supplier, (IEclipseContext)this.context);
        this.context.dispose();
    }
}

