/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabFolder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AreaRendererTest {
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.ems = (EModelService)this.appContext.get(EModelService.class);
    }

    @After
    public void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    @Test
    public void testMultipleStacksUnderTheAreaCreateACTabFolder() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        MPartStack stack1 = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack1.getChildren().add((MStackElement)this.ems.createModelElement(MPart.class));
        stack1.getChildren().add((MStackElement)this.ems.createModelElement(MPart.class));
        MPartStack stack2 = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack2.getChildren().add((MStackElement)this.ems.createModelElement(MPart.class));
        stack2.getChildren().add((MStackElement)this.ems.createModelElement(MPart.class));
        area.getChildren().add(stack1);
        area.getChildren().add(stack2);
        window.getChildren().add(area);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Assert.assertTrue((boolean)(area.getWidget() instanceof CTabFolder));
    }

    @Test
    public void testStackInsideMCompositePartDoesNotCreateACTabFolder() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        MCompositePart composite = (MCompositePart)this.ems.createModelElement(MCompositePart.class);
        MPartStack stack1 = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack1.getChildren().add((MStackElement)this.ems.createModelElement(MPart.class));
        stack1.getChildren().add((MStackElement)this.ems.createModelElement(MPart.class));
        MPartStack stack2 = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack2.getChildren().add((MStackElement)this.ems.createModelElement(MPart.class));
        stack2.getChildren().add((MStackElement)this.ems.createModelElement(MPart.class));
        composite.getChildren().add(stack1);
        composite.getChildren().add(stack2);
        area.getChildren().add(composite);
        window.getChildren().add(area);
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Assert.assertFalse((boolean)(area.getWidget() instanceof CTabFolder));
    }
}

