/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug308317Test {
    protected IEclipseContext appContext;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.ems = (EModelService)this.appContext.get(EModelService.class);
    }

    @After
    public void tearDown() throws Exception {
        this.appContext.dispose();
    }

    @Test
    public void testBug308317() throws Exception {
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackA);
        window.setSelectedElement((MUIElement)stackA);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stackB);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(partA);
        stackA.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(partB);
        stackB.setSelectedElement((MUIElement)partB);
        IEclipseContext windowContext = this.appContext.createChild();
        windowContext.set(MWindow.class.getName(), (Object)window);
        window.setContext(windowContext);
        IEclipseContext partContextA = windowContext.createChild();
        partContextA.set(MPart.class.getName(), (Object)partA);
        partA.setContext(partContextA);
        IEclipseContext partContextB = windowContext.createChild();
        partContextB.set(MPart.class.getName(), (Object)partB);
        partB.setContext(partContextB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        PartConsumer getter = (PartConsumer)ContextInjectionFactory.make(PartConsumer.class, (IEclipseContext)window.getContext());
        partA.getContext().activate();
        Assert.assertEquals((Object)partA, (Object)getter.part);
        partB.getContext().activate();
        Assert.assertEquals((Object)partB, (Object)getter.part);
        partA.getContext().activate();
        Assert.assertEquals((Object)partA, (Object)getter.part);
        partA.getContext().deactivate();
        Assert.assertEquals(null, (Object)getter.part);
        partB.getContext().dispose();
        partA.getContext().activate();
        Assert.assertEquals((Object)partA, (Object)getter.part);
    }

    static class PartConsumer {
        private MPart part;

        PartConsumer() {
        }

        @Inject
        void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
            this.part = part;
            if (part != null) {
                part.getContext().get("abc");
            }
        }
    }
}

