/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import jakarta.inject.Inject;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.tests.rules.WorkbenchContextRule;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CompositePartClosingTest {
    @Rule
    public WorkbenchContextRule contextRule = new WorkbenchContextRule();
    @Inject
    private EModelService ems;
    @Inject
    private MApplication application;
    @Inject
    private EPartService partService;

    @Test
    public void test_partClosing() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea rootArea = (MArea)this.ems.createModelElement(MArea.class);
        window.getChildren().add(rootArea);
        window.setSelectedElement((MUIElement)rootArea);
        MPartStack partStack1 = (MPartStack)this.ems.createModelElement(MPartStack.class);
        rootArea.getChildren().add(partStack1);
        MPartStack partStack2 = (MPartStack)this.ems.createModelElement(MPartStack.class);
        rootArea.getChildren().add(partStack2);
        MPart part1 = this.createPart();
        MCompositePart compositePart = this.createCompositePart();
        MPart part2 = this.createPart();
        partStack1.getChildren().add(compositePart);
        partStack1.getChildren().add(part1);
        partStack1.setSelectedElement((MUIElement)part1);
        partStack2.getChildren().add(part2);
        partStack2.setSelectedElement((MUIElement)part2);
        this.contextRule.createAndRunWorkbench(window);
        this.partService.activate(part2);
        this.partService.hidePart(part2);
        Assert.assertNotEquals((String)"Composite part got activated", (Object)compositePart, (Object)partStack1.getSelectedElement());
        Assert.assertEquals((String)"Wrong part got activated", (Object)part1, (Object)partStack1.getSelectedElement());
    }

    private MCompositePart createCompositePart() {
        MCompositePart compositePart = (MCompositePart)this.ems.createModelElement(MCompositePart.class);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        compositePart.getChildren().add(partSashContainer);
        partSashContainer.getChildren().add(partStack);
        partStack.getChildren().add(this.createPart());
        partStack.getChildren().add(this.createPart());
        return compositePart;
    }

    private MPart createPart() {
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return part;
    }
}

