/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.core.commands.contexts.Context;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.services.ContextServiceAddon;
import org.eclipse.e4.ui.services.EContextService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContextTest {
    private static final String WINDOW_ID = "org.eclipse.ui.contexts.window";
    private static final String DIALOG_ID = "org.eclipse.ui.contexts.dialog";
    private static final String DIALOG_AND_WINDOW_ID = "org.eclipse.ui.contexts.dialogAndWindow";
    private IEclipseContext appContext;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        ContextInjectionFactory.make(ContextServiceAddon.class, (IEclipseContext)this.appContext);
    }

    @After
    public void tearDown() throws Exception {
        this.appContext.dispose();
    }

    @Test
    public void testOneContext() throws Exception {
        this.defineContexts(this.appContext);
        EContextService cs = (EContextService)this.appContext.get(EContextService.class);
        Assert.assertEquals((long)0L, (long)cs.getActiveContextIds().size());
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        Assert.assertEquals((long)1L, (long)cs.getActiveContextIds().size());
    }

    @Test
    public void testTwoContexts() throws Exception {
        this.defineContexts(this.appContext);
        EContextService cs = (EContextService)this.appContext.get(EContextService.class);
        Assert.assertEquals((long)0L, (long)cs.getActiveContextIds().size());
        IEclipseContext window = this.appContext.createChild("windowContext");
        window.activate();
        EContextService windowService = (EContextService)window.get(EContextService.class);
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        Assert.assertEquals((long)1L, (long)cs.getActiveContextIds().size());
        Assert.assertEquals((long)1L, (long)windowService.getActiveContextIds().size());
        cs.deactivateContext(DIALOG_AND_WINDOW_ID);
        Assert.assertEquals((long)0L, (long)windowService.getActiveContextIds().size());
        Assert.assertEquals((long)0L, (long)cs.getActiveContextIds().size());
    }

    @Test
    public void testTwoContextsBottom() throws Exception {
        this.defineContexts(this.appContext);
        EContextService cs = (EContextService)this.appContext.get(EContextService.class);
        Assert.assertEquals((long)0L, (long)cs.getActiveContextIds().size());
        IEclipseContext window = this.appContext.createChild("windowContext");
        window.activate();
        EContextService windowService = (EContextService)window.get(EContextService.class);
        windowService.activateContext(DIALOG_AND_WINDOW_ID);
        Assert.assertEquals((long)1L, (long)cs.getActiveContextIds().size());
        Assert.assertEquals((long)1L, (long)windowService.getActiveContextIds().size());
        windowService.deactivateContext(DIALOG_AND_WINDOW_ID);
        Assert.assertEquals((long)0L, (long)windowService.getActiveContextIds().size());
        Assert.assertEquals((long)0L, (long)cs.getActiveContextIds().size());
        window.deactivate();
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        Assert.assertEquals((long)1L, (long)cs.getActiveContextIds().size());
        Assert.assertEquals((long)1L, (long)windowService.getActiveContextIds().size());
        cs.deactivateContext(DIALOG_AND_WINDOW_ID);
        Assert.assertEquals((long)0L, (long)windowService.getActiveContextIds().size());
        Assert.assertEquals((long)0L, (long)cs.getActiveContextIds().size());
    }

    @Test
    public void testThreeContexts() throws Exception {
        this.defineContexts(this.appContext);
        EContextService cs = (EContextService)this.appContext.get(EContextService.class);
        IEclipseContext window = this.appContext.createChild("windowContext");
        EContextService windowService = (EContextService)window.get(EContextService.class);
        IEclipseContext dialog = this.appContext.createChild("dialogContext");
        dialog.activate();
        EContextService dialogService = (EContextService)dialog.get(EContextService.class);
        cs.activateContext(DIALOG_AND_WINDOW_ID);
        windowService.activateContext(WINDOW_ID);
        Assert.assertEquals((long)1L, (long)cs.getActiveContextIds().size());
        Assert.assertEquals((long)1L, (long)dialogService.getActiveContextIds().size());
        Assert.assertEquals((long)2L, (long)windowService.getActiveContextIds().size());
        dialogService.activateContext(DIALOG_ID);
        Assert.assertEquals((long)2L, (long)cs.getActiveContextIds().size());
        Assert.assertEquals((long)2L, (long)dialogService.getActiveContextIds().size());
        Assert.assertEquals((long)2L, (long)windowService.getActiveContextIds().size());
        Assert.assertTrue((boolean)cs.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        Assert.assertTrue((boolean)cs.getActiveContextIds().contains(DIALOG_ID));
        Assert.assertFalse((boolean)cs.getActiveContextIds().contains(WINDOW_ID));
        Assert.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        Assert.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_ID));
        Assert.assertFalse((boolean)dialogService.getActiveContextIds().contains(WINDOW_ID));
        Assert.assertTrue((boolean)windowService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        Assert.assertFalse((boolean)windowService.getActiveContextIds().contains(DIALOG_ID));
        Assert.assertTrue((boolean)windowService.getActiveContextIds().contains(WINDOW_ID));
        window.activate();
        Assert.assertEquals((long)2L, (long)cs.getActiveContextIds().size());
        Assert.assertEquals((long)2L, (long)dialogService.getActiveContextIds().size());
        Assert.assertEquals((long)2L, (long)windowService.getActiveContextIds().size());
        Assert.assertTrue((boolean)cs.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        Assert.assertFalse((boolean)cs.getActiveContextIds().contains(DIALOG_ID));
        Assert.assertTrue((boolean)cs.getActiveContextIds().contains(WINDOW_ID));
        Assert.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        Assert.assertTrue((boolean)dialogService.getActiveContextIds().contains(DIALOG_ID));
        Assert.assertFalse((boolean)dialogService.getActiveContextIds().contains(WINDOW_ID));
        Assert.assertTrue((boolean)windowService.getActiveContextIds().contains(DIALOG_AND_WINDOW_ID));
        Assert.assertFalse((boolean)windowService.getActiveContextIds().contains(DIALOG_ID));
        Assert.assertTrue((boolean)windowService.getActiveContextIds().contains(WINDOW_ID));
    }

    private void defineContexts(IEclipseContext appContext) {
        EContextService cs = (EContextService)appContext.get(EContextService.class);
        Context daw = cs.getContext(DIALOG_AND_WINDOW_ID);
        daw.define("Dialog and Window", null, null);
        Context d = cs.getContext(DIALOG_ID);
        d.define("Dialog", null, DIALOG_AND_WINDOW_ID);
        Context w = cs.getContext(WINDOW_ID);
        w.define("Window", null, DIALOG_AND_WINDOW_ID);
    }
}

